/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.command;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.neo4j.collection.primitive.PrimitiveLongObjectMap;
import org.neo4j.concurrent.Work;
import org.neo4j.helpers.collection.NestingIterator;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.impl.api.index.IndexingUpdateService;
import org.neo4j.kernel.impl.store.UnderlyingStorageException;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.impl.transaction.state.IndexUpdates;

public class IndexUpdatesWork
implements Work<IndexingUpdateService, IndexUpdatesWork> {
    private final List<IndexUpdates> updates = new ArrayList<IndexUpdates>();

    public IndexUpdatesWork(IndexUpdates updates) {
        this.updates.add(updates);
    }

    public IndexUpdatesWork combine(IndexUpdatesWork work) {
        this.updates.addAll(work.updates);
        return this;
    }

    public void apply(IndexingUpdateService material) {
        try {
            material.apply(this.combinedUpdates());
        }
        catch (IOException | IndexEntryConflictException e) {
            throw new UnderlyingStorageException(e);
        }
    }

    private IndexUpdates combinedUpdates() {
        return new IndexUpdates(){

            @Override
            public Iterator<IndexEntryUpdate<SchemaDescriptor>> iterator() {
                return new NestingIterator<IndexEntryUpdate<SchemaDescriptor>, IndexUpdates>(IndexUpdatesWork.this.updates.iterator()){

                    protected Iterator<IndexEntryUpdate<SchemaDescriptor>> createNestedIterator(IndexUpdates item) {
                        return item.iterator();
                    }
                };
            }

            @Override
            public void feed(PrimitiveLongObjectMap<List<Command.PropertyCommand>> propCommands, PrimitiveLongObjectMap<Command.NodeCommand> nodeCommands) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean hasUpdates() {
                return true;
            }
        };
    }
}

