/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.labelscan;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collection;
import org.neo4j.cursor.RawCursor;
import org.neo4j.index.internal.gbptree.Hit;
import org.neo4j.kernel.impl.index.labelscan.LabelScanKey;
import org.neo4j.kernel.impl.index.labelscan.LabelScanValue;

abstract class LabelScanValueIndexAccessor {
    protected final RawCursor<Hit<LabelScanKey, LabelScanValue>, IOException> cursor;
    private final Collection<RawCursor<Hit<LabelScanKey, LabelScanValue>, IOException>> toRemoveFromWhenClosed;
    long baseNodeId;
    protected long bits;
    private int prevLabel = -1;
    private long prevRange = -1L;
    protected boolean closed;

    LabelScanValueIndexAccessor(Collection<RawCursor<Hit<LabelScanKey, LabelScanValue>, IOException>> toRemoveFromWhenClosed, RawCursor<Hit<LabelScanKey, LabelScanValue>, IOException> cursor) {
        this.toRemoveFromWhenClosed = toRemoveFromWhenClosed;
        this.cursor = cursor;
    }

    boolean keysInOrder(LabelScanKey key) {
        assert (key.labelId >= this.prevLabel) : "Expected to get ordered results, got " + key + " where previous label was " + this.prevLabel;
        assert (key.idRange > this.prevRange) : "Expected to get ordered results, got " + key + " where previous range was " + this.prevRange;
        this.prevLabel = key.labelId;
        this.prevRange = key.idRange;
        return true;
    }

    public void close() {
        if (!this.closed) {
            try {
                this.cursor.close();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            finally {
                this.toRemoveFromWhenClosed.remove(this.cursor);
                this.closed = true;
            }
        }
    }
}

