/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.Comparator;
import org.neo4j.cursor.RawCursor;
import org.neo4j.index.internal.gbptree.Hit;
import org.neo4j.kernel.impl.index.schema.NativeIndexProgressor;
import org.neo4j.kernel.impl.index.schema.NativeSchemaKey;
import org.neo4j.kernel.impl.index.schema.NativeSchemaValue;
import org.neo4j.kernel.impl.index.schema.SchemaLayout;
import org.neo4j.storageengine.api.schema.IndexProgressor;

public class NativeDistinctValuesProgressor<KEY extends NativeSchemaKey<KEY>, VALUE extends NativeSchemaValue>
extends NativeIndexProgressor<KEY, VALUE> {
    private final SchemaLayout<KEY> layout;
    private final KEY prev;
    private final Comparator<KEY> comparator;
    private boolean first = true;
    private long countForCurrentValue;
    private boolean last;

    NativeDistinctValuesProgressor(RawCursor<Hit<KEY, VALUE>, IOException> seeker, IndexProgressor.NodeValueClient client, Collection<RawCursor<Hit<KEY, VALUE>, IOException>> toRemoveFromOnClose, SchemaLayout<KEY> layout, Comparator<KEY> comparator) {
        super(seeker, client, toRemoveFromOnClose);
        this.layout = layout;
        this.prev = (NativeSchemaKey)((Object)layout.newKey());
        this.comparator = comparator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean next() {
        try {
            while (this.seeker.next()) {
                NativeSchemaKey key = (NativeSchemaKey)((Object)((Hit)this.seeker.get()).key());
                try {
                    if (this.first) {
                        this.first = false;
                        this.countForCurrentValue = 1L;
                        continue;
                    }
                    if (this.comparator.compare(this.prev, (KEY)((Object)key)) == 0) {
                        ++this.countForCurrentValue;
                        continue;
                    }
                    boolean accepted = this.client.acceptNode(this.countForCurrentValue, this.extractValues(this.prev));
                    this.countForCurrentValue = 1L;
                    if (!accepted) continue;
                    boolean bl = true;
                    return bl;
                }
                finally {
                    this.layout.copyKey((Object)key, this.prev);
                }
            }
            boolean finalResult = !this.first && !this.last && this.client.acceptNode(this.countForCurrentValue, this.extractValues(this.prev));
            this.last = true;
            return finalResult;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

