/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema.fusion;

import java.util.Arrays;
import java.util.function.Function;
import org.neo4j.function.ThrowingConsumer;
import org.neo4j.helpers.Exceptions;
import org.neo4j.kernel.impl.index.schema.fusion.InstanceSelector;
import org.neo4j.kernel.impl.index.schema.fusion.SlotSelector;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;

public abstract class FusionIndexBase<T> {
    static Function<Value, ValueGroup> GROUP_OF = Value::valueGroup;
    final SlotSelector slotSelector;
    final InstanceSelector<T> instanceSelector;

    FusionIndexBase(SlotSelector slotSelector, InstanceSelector<T> instanceSelector) {
        this.slotSelector = slotSelector;
        this.instanceSelector = instanceSelector;
    }

    public static <T, E extends Exception> void forAll(ThrowingConsumer<T, E> consumer, Iterable<T> subjects) throws E {
        Object exception = null;
        for (T instance : subjects) {
            exception = FusionIndexBase.consume(exception, consumer, instance);
        }
        if (exception != null) {
            throw exception;
        }
    }

    public static <T, E extends Exception> void forAll(ThrowingConsumer<T, E> consumer, T[] subjects) throws E {
        FusionIndexBase.forAll(consumer, Arrays.asList(subjects));
    }

    private static <E extends Exception, T> E consume(E exception, ThrowingConsumer<T, E> consumer, T instance) {
        try {
            consumer.accept(instance);
        }
        catch (Exception e) {
            exception = (Exception)Exceptions.chain(exception, (Throwable)e);
        }
        return exception;
    }
}

