/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema.fusion;

import java.util.Arrays;
import org.neo4j.collection.primitive.PrimitiveLongResourceCollections;
import org.neo4j.collection.primitive.PrimitiveLongResourceIterator;
import org.neo4j.graphdb.Resource;
import org.neo4j.internal.kernel.api.IndexOrder;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.kernel.api.exceptions.index.IndexNotApplicableKernelException;
import org.neo4j.kernel.api.index.PropertyAccessor;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptor;
import org.neo4j.kernel.impl.api.schema.BridgingIndexProgressor;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexBase;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexSampler;
import org.neo4j.kernel.impl.index.schema.fusion.LazyInstanceSelector;
import org.neo4j.kernel.impl.index.schema.fusion.SlotSelector;
import org.neo4j.storageengine.api.schema.IndexProgressor;
import org.neo4j.storageengine.api.schema.IndexReader;
import org.neo4j.storageengine.api.schema.IndexSampler;
import org.neo4j.values.storable.Value;

class FusionIndexReader
extends FusionIndexBase<IndexReader>
implements IndexReader {
    private final SchemaIndexDescriptor descriptor;

    FusionIndexReader(SlotSelector slotSelector, LazyInstanceSelector<IndexReader> instanceSelector, SchemaIndexDescriptor descriptor) {
        super(slotSelector, instanceSelector);
        this.descriptor = descriptor;
    }

    public void close() {
        this.instanceSelector.close(Resource::close);
    }

    @Override
    public long countIndexedNodes(long nodeId, Value ... propertyValues) {
        return ((IndexReader)this.instanceSelector.select(this.slotSelector.selectSlot(propertyValues, GROUP_OF))).countIndexedNodes(nodeId, propertyValues);
    }

    @Override
    public IndexSampler createSampler() {
        return new FusionIndexSampler(this.instanceSelector.instancesAs(new IndexSampler[5], IndexReader::createSampler));
    }

    @Override
    public PrimitiveLongResourceIterator query(IndexQuery ... predicates) throws IndexNotApplicableKernelException {
        int slot = this.slotSelector.selectSlot(predicates, IndexQuery::valueGroup);
        return slot != -1 ? ((IndexReader)this.instanceSelector.select(slot)).query(predicates) : PrimitiveLongResourceCollections.concat((PrimitiveLongResourceIterator[])this.instanceSelector.instancesAs(new PrimitiveLongResourceIterator[5], reader -> reader.query(predicates)));
    }

    @Override
    public void query(IndexProgressor.NodeValueClient cursor, IndexOrder indexOrder, IndexQuery ... predicates) throws IndexNotApplicableKernelException {
        int slot = this.slotSelector.selectSlot(predicates, IndexQuery::valueGroup);
        if (slot != -1) {
            ((IndexReader)this.instanceSelector.select(slot)).query(cursor, indexOrder, predicates);
        } else {
            if (indexOrder != IndexOrder.NONE) {
                throw new UnsupportedOperationException(String.format("Tried to query index with unsupported order %s. Supported orders for query %s are %s.", indexOrder, Arrays.toString(predicates), IndexOrder.NONE));
            }
            BridgingIndexProgressor multiProgressor = new BridgingIndexProgressor(cursor, this.descriptor.schema().getPropertyIds());
            cursor.initialize(this.descriptor, multiProgressor, predicates);
            this.instanceSelector.forAll(reader -> reader.query(multiProgressor, indexOrder, predicates));
        }
    }

    @Override
    public void distinctValues(IndexProgressor.NodeValueClient cursor, PropertyAccessor propertyAccessor) {
        BridgingIndexProgressor multiProgressor = new BridgingIndexProgressor(cursor, this.descriptor.schema().getPropertyIds());
        cursor.initialize(this.descriptor, multiProgressor, new IndexQuery[0]);
        this.instanceSelector.forAll(reader -> reader.distinctValues(multiProgressor, propertyAccessor));
    }

    @Override
    public boolean hasFullValuePrecision(IndexQuery ... predicates) {
        int slot = this.slotSelector.selectSlot(predicates, IndexQuery::valueGroup);
        if (slot != -1) {
            return ((IndexReader)this.instanceSelector.select(slot)).hasFullValuePrecision(predicates);
        }
        if (predicates.length != 1 || !(predicates[0] instanceof IndexQuery.ExistsPredicate)) {
            throw new IllegalStateException("Selected IndexReader null for predicates " + Arrays.toString(predicates));
        }
        return true;
    }
}

