/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.checkpoint;

import java.time.Clock;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointThreshold;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointThresholdPolicy;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CountCommittedTransactionThreshold;
import org.neo4j.kernel.impl.transaction.log.checkpoint.TimeCheckPointThreshold;
import org.neo4j.kernel.impl.transaction.log.pruning.LogPruning;
import org.neo4j.logging.LogProvider;

public class PeriodicThresholdPolicy
extends CheckPointThresholdPolicy {
    public PeriodicThresholdPolicy() {
        super("periodic", new String[0]);
    }

    @Override
    public CheckPointThreshold createThreshold(Config config, Clock clock, LogPruning logPruning, LogProvider logProvider) {
        int txThreshold = config.get(GraphDatabaseSettings.check_point_interval_tx);
        CountCommittedTransactionThreshold countCommittedTransactionThreshold = new CountCommittedTransactionThreshold(txThreshold);
        long timeMillisThreshold = config.get(GraphDatabaseSettings.check_point_interval_time).toMillis();
        TimeCheckPointThreshold timeCheckPointThreshold = new TimeCheckPointThreshold(timeMillisThreshold, clock);
        return CheckPointThreshold.or(countCommittedTransactionThreshold, timeCheckPointThreshold);
    }
}

