/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.factory;

import java.io.File;
import java.net.URL;
import java.util.Map;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.config.Configuration;
import org.neo4j.graphdb.event.KernelEventHandler;
import org.neo4j.graphdb.event.TransactionEventHandler;
import org.neo4j.graphdb.security.URLAccessValidationError;
import org.neo4j.internal.kernel.api.Kernel;
import org.neo4j.internal.kernel.api.Transaction;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.kernel.GraphDatabaseQueryService;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.explicitindex.AutoIndexing;
import org.neo4j.kernel.impl.coreapi.CoreAPIAvailabilityGuard;
import org.neo4j.kernel.impl.factory.DataSourceModule;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.kernel.impl.factory.PlatformModule;
import org.neo4j.kernel.impl.query.QueryExecutionKernelException;
import org.neo4j.kernel.impl.query.TransactionalContext;
import org.neo4j.kernel.impl.store.StoreId;
import org.neo4j.kernel.lifecycle.LifecycleException;
import org.neo4j.logging.Logger;
import org.neo4j.values.virtual.MapValue;

class ClassicCoreSPI
implements GraphDatabaseFacade.SPI {
    private final PlatformModule platform;
    private final DataSourceModule dataSource;
    private final Logger msgLog;
    private final CoreAPIAvailabilityGuard availability;

    ClassicCoreSPI(PlatformModule platform, DataSourceModule dataSource, Logger msgLog, CoreAPIAvailabilityGuard availability) {
        this.platform = platform;
        this.dataSource = dataSource;
        this.msgLog = msgLog;
        this.availability = availability;
    }

    @Override
    public boolean databaseIsAvailable(long timeout) {
        return this.platform.availabilityGuard.isAvailable(timeout);
    }

    @Override
    public Result executeQuery(String query, MapValue parameters, TransactionalContext transactionalContext) {
        try {
            this.availability.assertDatabaseAvailable();
            return this.dataSource.queryExecutor.get().executeQuery(query, parameters, transactionalContext);
        }
        catch (QueryExecutionKernelException e) {
            throw e.asUserException();
        }
    }

    @Override
    public Result executeQuery(String query, Map<String, Object> parameters, TransactionalContext transactionalContext) {
        try {
            this.availability.assertDatabaseAvailable();
            return this.dataSource.queryExecutor.get().executeQuery(query, parameters, transactionalContext);
        }
        catch (QueryExecutionKernelException e) {
            throw e.asUserException();
        }
    }

    @Override
    public AutoIndexing autoIndexing() {
        return this.dataSource.autoIndexing;
    }

    @Override
    public DependencyResolver resolver() {
        return this.platform.dependencies;
    }

    @Override
    public void registerKernelEventHandler(KernelEventHandler handler) {
        this.dataSource.kernelEventHandlers.registerKernelEventHandler(handler);
    }

    @Override
    public void unregisterKernelEventHandler(KernelEventHandler handler) {
        this.dataSource.kernelEventHandlers.unregisterKernelEventHandler(handler);
    }

    @Override
    public <T> void registerTransactionEventHandler(TransactionEventHandler<T> handler) {
        this.dataSource.transactionEventHandlers.registerTransactionEventHandler(handler);
    }

    @Override
    public <T> void unregisterTransactionEventHandler(TransactionEventHandler<T> handler) {
        this.dataSource.transactionEventHandlers.unregisterTransactionEventHandler(handler);
    }

    @Override
    public StoreId storeId() {
        return this.dataSource.storeId.get();
    }

    @Override
    public File storeDir() {
        return this.platform.storeDir;
    }

    @Override
    public URL validateURLAccess(URL url) throws URLAccessValidationError {
        return this.platform.urlAccessRule.validate((Configuration)this.platform.config, url);
    }

    @Override
    public GraphDatabaseQueryService queryService() {
        return (GraphDatabaseQueryService)this.platform.dependencies.resolveDependency(GraphDatabaseQueryService.class);
    }

    @Override
    public Kernel kernel() {
        return (Kernel)this.resolver().resolveDependency(Kernel.class);
    }

    @Override
    public String name() {
        return this.platform.databaseInfo.toString();
    }

    @Override
    public void shutdown() {
        try {
            this.msgLog.log("Shutdown started");
            this.platform.availabilityGuard.shutdown();
            this.platform.life.shutdown();
        }
        catch (LifecycleException throwable) {
            this.msgLog.log("Shutdown failed", (Throwable)throwable);
            throw throwable;
        }
    }

    @Override
    public KernelTransaction beginTransaction(Transaction.Type type, LoginContext loginContext, long timeout) {
        try {
            this.availability.assertDatabaseAvailable();
            KernelTransaction kernelTx = this.dataSource.kernelAPI.get().newTransaction(type, loginContext, timeout);
            kernelTx.registerCloseListener(txId -> this.dataSource.threadToTransactionBridge.unbindTransactionFromCurrentThread());
            this.dataSource.threadToTransactionBridge.bindTransactionToCurrentThread(kernelTx);
            return kernelTx;
        }
        catch (TransactionFailureException e) {
            throw new org.neo4j.graphdb.TransactionFailureException(e.getMessage(), (Throwable)e);
        }
    }
}

