/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.io.IOException;
import java.util.Iterator;
import java.util.function.LongConsumer;
import org.neo4j.helpers.Format;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.io.pagecache.tracing.cursor.context.EmptyVersionContext;
import org.neo4j.io.pagecache.tracing.cursor.context.VersionContext;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.Commitment;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.util.HexPrinter;
import org.neo4j.storageengine.api.CommandsToApply;
import org.neo4j.storageengine.api.StorageCommand;

public class TransactionToApply
implements CommandsToApply,
AutoCloseable {
    public static final long TRANSACTION_ID_NOT_SPECIFIED = 0L;
    private final TransactionRepresentation transactionRepresentation;
    private long transactionId;
    private final VersionContext versionContext;
    private TransactionToApply nextTransactionInBatch;
    private Commitment commitment;
    private LongConsumer closedCallback;
    private LogPosition logPosition;

    public TransactionToApply(TransactionRepresentation transactionRepresentation) {
        this(transactionRepresentation, EmptyVersionContext.EMPTY);
    }

    public TransactionToApply(TransactionRepresentation transactionRepresentation, VersionContext versionContext) {
        this(transactionRepresentation, 0L, versionContext);
    }

    public TransactionToApply(TransactionRepresentation transactionRepresentation, long transactionId) {
        this(transactionRepresentation, transactionId, EmptyVersionContext.EMPTY);
    }

    public TransactionToApply(TransactionRepresentation transactionRepresentation, long transactionId, VersionContext versionContext) {
        this.transactionRepresentation = transactionRepresentation;
        this.transactionId = transactionId;
        this.versionContext = versionContext;
    }

    public void next(TransactionToApply next) {
        this.nextTransactionInBatch = next;
    }

    public Commitment commitment() {
        return this.commitment;
    }

    public long transactionId() {
        return this.transactionId;
    }

    public boolean accept(Visitor<StorageCommand, IOException> visitor) throws IOException {
        return this.transactionRepresentation.accept(visitor);
    }

    public TransactionRepresentation transactionRepresentation() {
        return this.transactionRepresentation;
    }

    public boolean requiresApplicationOrdering() {
        return this.commitment.hasExplicitIndexChanges();
    }

    public void commitment(Commitment commitment, long transactionId) {
        this.commitment = commitment;
        this.transactionId = transactionId;
        this.versionContext.initWrite(transactionId);
    }

    public void logPosition(LogPosition position) {
        this.logPosition = position;
    }

    public TransactionToApply next() {
        return this.nextTransactionInBatch;
    }

    public void onClose(LongConsumer closedCallback) {
        this.closedCallback = closedCallback;
    }

    @Override
    public void close() {
        if (this.closedCallback != null) {
            this.closedCallback.accept(this.transactionId);
        }
    }

    public String toString() {
        TransactionRepresentation tr = this.transactionRepresentation;
        return "Transaction #" + this.transactionId + (this.logPosition != null ? " at log position " + this.logPosition : " (no log position)") + " {started " + Format.date(tr.getTimeStarted()) + ", committed " + Format.date(tr.getTimeCommitted()) + ", with " + this.countCommands() + " commands in this transaction, authored by " + tr.getAuthorId() + ", with master id " + tr.getMasterId() + ", lock session " + tr.getLockSessionId() + ", latest committed transaction id when started was " + tr.getLatestCommittedTxWhenStarted() + ", additional header bytes: " + HexPrinter.hex(tr.additionalHeader(), Integer.MAX_VALUE, "") + "}";
    }

    private String countCommands() {
        try {
            class Counter
            implements Visitor<StorageCommand, IOException> {
                private int count;

                Counter() {
                }

                public boolean visit(StorageCommand element) {
                    ++this.count;
                    return false;
                }
            }
            Counter counter = new Counter();
            this.accept(counter);
            return String.valueOf(counter.count);
        }
        catch (Throwable e) {
            return "(unable to count: " + e.getMessage() + ")";
        }
    }

    public Iterator<StorageCommand> iterator() {
        return this.transactionRepresentation.iterator();
    }
}

