/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.io.Serializable;
import java.util.Collection;
import org.apache.commons.lang3.ArrayUtils;
import org.eclipse.collections.api.block.function.Function0;
import org.eclipse.collections.api.map.primitive.MutableIntObjectMap;
import org.eclipse.collections.impl.factory.primitive.IntObjectMaps;
import org.neo4j.common.EntityType;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.newapi.NodeSchemaMatcher;
import org.neo4j.kernel.impl.newapi.Read;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueTuple;
import org.neo4j.values.storable.Values;

public class IndexTxStateUpdater {
    private final StorageReader storageReader;
    private final Read read;
    private final IndexingService indexingService;

    public IndexTxStateUpdater(StorageReader storageReader, Read read, IndexingService indexingService) {
        this.storageReader = storageReader;
        this.read = read;
        this.indexingService = indexingService;
    }

    void onLabelChange(int labelId, int[] existingPropertyKeyIds, NodeCursor node, PropertyCursor propertyCursor, LabelChangeType changeType) {
        assert (this.noSchemaChangedInTx());
        Collection indexes = this.storageReader.indexesGetRelated(new long[]{labelId}, existingPropertyKeyIds, EntityType.NODE);
        if (!indexes.isEmpty()) {
            MutableIntObjectMap materializedProperties = IntObjectMaps.mutable.empty();
            block4: for (IndexDescriptor index : indexes) {
                int[] indexPropertyIds = index.schema().getPropertyIds();
                Value[] values = this.getValueTuple(node, propertyCursor, -1, Values.NO_VALUE, indexPropertyIds, (MutableIntObjectMap<Value>)materializedProperties);
                switch (changeType) {
                    case ADDED_LABEL: {
                        this.indexingService.validateBeforeCommit(index, values);
                        this.read.txState().indexDoUpdateEntry(index.schema(), node.nodeReference(), null, ValueTuple.of((Value[])values));
                        continue block4;
                    }
                    case REMOVED_LABEL: {
                        this.read.txState().indexDoUpdateEntry(index.schema(), node.nodeReference(), ValueTuple.of((Value[])values), null);
                        continue block4;
                    }
                }
                throw new IllegalStateException(changeType + " is not a supported event");
            }
        }
    }

    private boolean noSchemaChangedInTx() {
        return !this.read.txState().hasChanges() || this.read.txState().hasDataChanges();
    }

    void onPropertyAdd(NodeCursor node, PropertyCursor propertyCursor, long[] labels, int propertyKeyId, int[] existingPropertyKeyIds, Value value) {
        assert (this.noSchemaChangedInTx());
        Collection indexes = this.storageReader.indexesGetRelated(labels, propertyKeyId, EntityType.NODE);
        if (!indexes.isEmpty()) {
            MutableIntObjectMap materializedProperties = IntObjectMaps.mutable.empty();
            NodeSchemaMatcher.onMatchingSchema(indexes.iterator(), propertyKeyId, existingPropertyKeyIds, index -> {
                SchemaDescriptor schema = index.schema();
                Value[] values = this.getValueTuple(node, propertyCursor, propertyKeyId, value, schema.getPropertyIds(), (MutableIntObjectMap<Value>)materializedProperties);
                this.indexingService.validateBeforeCommit((IndexDescriptor)index, values);
                this.read.txState().indexDoUpdateEntry(schema, node.nodeReference(), null, ValueTuple.of((Value[])values));
            });
        }
    }

    void onPropertyRemove(NodeCursor node, PropertyCursor propertyCursor, long[] labels, int propertyKeyId, int[] existingPropertyKeyIds, Value value) {
        assert (this.noSchemaChangedInTx());
        Collection indexes = this.storageReader.indexesGetRelated(labels, propertyKeyId, EntityType.NODE);
        if (!indexes.isEmpty()) {
            MutableIntObjectMap materializedProperties = IntObjectMaps.mutable.empty();
            NodeSchemaMatcher.onMatchingSchema(indexes.iterator(), propertyKeyId, existingPropertyKeyIds, index -> {
                SchemaDescriptor schema = index.schema();
                Value[] values = this.getValueTuple(node, propertyCursor, propertyKeyId, value, schema.getPropertyIds(), (MutableIntObjectMap<Value>)materializedProperties);
                this.read.txState().indexDoUpdateEntry(schema, node.nodeReference(), ValueTuple.of((Value[])values), null);
            });
        }
    }

    void onPropertyChange(NodeCursor node, PropertyCursor propertyCursor, long[] labels, int propertyKeyId, int[] existingPropertyKeyIds, Value beforeValue, Value afterValue) {
        assert (this.noSchemaChangedInTx());
        Collection indexes = this.storageReader.indexesGetRelated(labels, propertyKeyId, EntityType.NODE);
        if (!indexes.isEmpty()) {
            MutableIntObjectMap materializedProperties = IntObjectMaps.mutable.empty();
            NodeSchemaMatcher.onMatchingSchema(indexes.iterator(), propertyKeyId, existingPropertyKeyIds, index -> {
                SchemaDescriptor schema = index.schema();
                int[] propertyIds = schema.getPropertyIds();
                Value[] valuesAfter = this.getValueTuple(node, propertyCursor, propertyKeyId, afterValue, propertyIds, (MutableIntObjectMap<Value>)materializedProperties);
                Value[] valuesBefore = (Value[])valuesAfter.clone();
                int k = ArrayUtils.indexOf((int[])propertyIds, (int)propertyKeyId);
                valuesBefore[k] = beforeValue;
                this.indexingService.validateBeforeCommit((IndexDescriptor)index, valuesAfter);
                this.read.txState().indexDoUpdateEntry(schema, node.nodeReference(), ValueTuple.of((Value[])valuesBefore), ValueTuple.of((Value[])valuesAfter));
            });
        }
    }

    private Value[] getValueTuple(NodeCursor node, PropertyCursor propertyCursor, int changedPropertyKeyId, Value changedValue, int[] indexPropertyIds, MutableIntObjectMap<Value> materializedValues) {
        int k;
        Value[] values = new Value[indexPropertyIds.length];
        int missing = 0;
        for (k = 0; k < indexPropertyIds.length; ++k) {
            Value value = values[k] = indexPropertyIds[k] == changedPropertyKeyId ? changedValue : (Value)materializedValues.getIfAbsent(indexPropertyIds[k], (Function0 & Serializable)() -> Values.NO_VALUE);
            if (values[k] != Values.NO_VALUE) continue;
            ++missing;
        }
        if (missing > 0) {
            node.properties(propertyCursor);
            while (missing > 0 && propertyCursor.next()) {
                k = ArrayUtils.indexOf((int[])indexPropertyIds, (int)propertyCursor.propertyKey());
                if (k < 0 || values[k] != Values.NO_VALUE) continue;
                int propertyKeyId = indexPropertyIds[k];
                boolean thisIsTheChangedProperty = propertyKeyId == changedPropertyKeyId;
                Value value = values[k] = thisIsTheChangedProperty ? changedValue : propertyCursor.propertyValue();
                if (!thisIsTheChangedProperty) {
                    materializedValues.put(propertyKeyId, (Object)values[k]);
                }
                --missing;
            }
        }
        return values;
    }

    public static enum LabelChangeType {
        ADDED_LABEL,
        REMOVED_LABEL;

    }
}

