/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state.storeview;

import java.util.function.IntPredicate;
import java.util.function.Supplier;
import org.neo4j.internal.helpers.collection.Visitor;
import org.neo4j.kernel.impl.api.index.IndexStoreView;
import org.neo4j.kernel.impl.api.index.StoreScan;
import org.neo4j.kernel.impl.transaction.state.storeview.DefaultNodePropertyAccessor;
import org.neo4j.kernel.impl.transaction.state.storeview.RelationshipStoreScan;
import org.neo4j.kernel.impl.transaction.state.storeview.StoreViewNodeStoreScan;
import org.neo4j.lock.LockService;
import org.neo4j.storageengine.api.EntityUpdates;
import org.neo4j.storageengine.api.NodeLabelUpdate;
import org.neo4j.storageengine.api.NodePropertyAccessor;
import org.neo4j.storageengine.api.StorageReader;

public class NeoStoreIndexStoreView
implements IndexStoreView {
    protected final LockService locks;
    protected final Supplier<StorageReader> storageEngine;

    public NeoStoreIndexStoreView(LockService locks, Supplier<StorageReader> storageEngine) {
        this.locks = locks;
        this.storageEngine = storageEngine;
    }

    @Override
    public <FAILURE extends Exception> StoreScan<FAILURE> visitNodes(int[] labelIds, IntPredicate propertyKeyIdFilter, Visitor<EntityUpdates, FAILURE> propertyUpdatesVisitor, Visitor<NodeLabelUpdate, FAILURE> labelUpdateVisitor, boolean forceStoreScan) {
        return new StoreViewNodeStoreScan<FAILURE>(this.storageEngine.get(), this.locks, labelUpdateVisitor, propertyUpdatesVisitor, labelIds, propertyKeyIdFilter);
    }

    @Override
    public <FAILURE extends Exception> StoreScan<FAILURE> visitRelationships(int[] relationshipTypeIds, IntPredicate propertyKeyIdFilter, Visitor<EntityUpdates, FAILURE> propertyUpdatesVisitor) {
        return new RelationshipStoreScan<FAILURE>(this.storageEngine.get(), this.locks, propertyUpdatesVisitor, relationshipTypeIds, propertyKeyIdFilter);
    }

    @Override
    public NodePropertyAccessor newPropertyAccessor() {
        return new DefaultNodePropertyAccessor(this.storageEngine.get());
    }
}

