/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.internal;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Version {
    private static final String KERNEL_ARTIFACT_ID = "neo4j-kernel";
    private static final Version KERNEL_VERSION = new Version("neo4j-kernel", Version.class.getPackage().getImplementationVersion());
    private static final String VENDOR = "Neo Technology";
    private final String artifactId;
    private final String title;
    private final String version;
    private final String releaseVersion;

    public static Version getKernel() {
        return KERNEL_VERSION;
    }

    public static String getKernelVersion() {
        return Version.getKernel().getVersion();
    }

    public static String getNeo4jVersion() {
        return Version.getKernel().getReleaseVersion();
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        if (this.title != null) {
            result.append(this.title);
            if (this.artifactId == null || !this.artifactId.equals(this.title)) {
                result.append(" (").append(this.artifactId).append(')');
            }
        } else {
            result.append(Objects.requireNonNullElse(this.artifactId, "Unknown Component"));
        }
        result.append(", ");
        if (this.title == null) {
            result.append("unpackaged ");
        }
        result.append("version: ").append(this.getVersion());
        return result.toString();
    }

    public final String getVersion() {
        return this.version;
    }

    public String getReleaseVersion() {
        return this.releaseVersion;
    }

    protected Version(String artifactId, String version) {
        this.artifactId = artifactId;
        this.title = artifactId;
        this.version = version == null ? "dev" : version;
        this.releaseVersion = this.parseReleaseVersion(this.version);
    }

    private String parseReleaseVersion(String fullVersion) {
        Pattern pattern = Pattern.compile("(\\d+\\.\\d+(\\.\\d+)?(-?[^,]+)?).*");
        Matcher matcher = pattern.matcher(fullVersion);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return this.version;
    }
}

