/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.internal.locker;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.kernel.internal.locker.FileLockException;

public class Locker
implements Closeable {
    private final FileSystemAbstraction fileSystemAbstraction;
    private final File lockFile;
    FileLock lockFileLock;
    private StoreChannel lockFileChannel;

    public Locker(FileSystemAbstraction fileSystemAbstraction, File lockFile) {
        this.fileSystemAbstraction = fileSystemAbstraction;
        this.lockFile = lockFile;
    }

    public final File lockFile() {
        return this.lockFile;
    }

    public void checkLock() throws FileLockException {
        if (this.haveLockAlready()) {
            return;
        }
        try {
            if (!this.fileSystemAbstraction.fileExists(this.lockFile)) {
                this.fileSystemAbstraction.mkdirs(this.lockFile.getParentFile());
            }
        }
        catch (IOException e) {
            String message = "Unable to create path for dir: " + this.lockFile.getParent();
            throw Locker.storeLockException(message, e);
        }
        try {
            if (this.lockFileChannel == null) {
                this.lockFileChannel = this.fileSystemAbstraction.write(this.lockFile);
            }
            this.lockFileLock = this.lockFileChannel.tryLock();
            if (this.lockFileLock == null) {
                String message = "Lock file has been locked by another process: " + this.lockFile;
                throw Locker.storeLockException(message, null);
            }
        }
        catch (IOException | OverlappingFileLockException e) {
            throw this.unableToObtainLockException();
        }
    }

    protected boolean haveLockAlready() {
        return this.lockFileLock != null && this.lockFileChannel != null;
    }

    FileLockException unableToObtainLockException() {
        String message = "Unable to obtain lock on file: " + this.lockFile;
        return Locker.storeLockException(message, null);
    }

    private static FileLockException storeLockException(String message, Exception e) {
        String help = "Please ensure no other process is using this database, and that the directory is writable (required even for read-only access)";
        return new FileLockException(message + ". " + help, e);
    }

    @Override
    public void close() throws IOException {
        if (this.lockFileLock != null) {
            this.releaseLock();
        }
        if (this.lockFileChannel != null) {
            this.releaseChannel();
        }
    }

    private void releaseChannel() throws IOException {
        this.lockFileChannel.close();
        this.lockFileChannel = null;
    }

    protected void releaseLock() throws IOException {
        this.lockFileLock.release();
        this.lockFileLock = null;
    }
}

