/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.scan;

import java.io.IOException;
import org.apache.commons.lang3.ArrayUtils;
import org.neo4j.function.Predicates;
import org.neo4j.internal.helpers.collection.Visitor;
import org.neo4j.internal.index.label.FullStoreChangeStream;
import org.neo4j.internal.index.label.LabelScanWriter;
import org.neo4j.kernel.impl.api.index.IndexStoreView;
import org.neo4j.kernel.impl.api.index.StoreScan;
import org.neo4j.storageengine.api.NodeLabelUpdate;

public class FullLabelStream
implements FullStoreChangeStream,
Visitor<NodeLabelUpdate, IOException> {
    private final IndexStoreView indexStoreView;
    private LabelScanWriter writer;
    private long count;

    public FullLabelStream(IndexStoreView indexStoreView) {
        this.indexStoreView = indexStoreView;
    }

    public long applyTo(LabelScanWriter writer) throws IOException {
        this.writer = writer;
        StoreScan<IOException> scan = this.indexStoreView.visitNodes(ArrayUtils.EMPTY_INT_ARRAY, Predicates.ALWAYS_TRUE_INT, null, this, true);
        scan.run();
        return this.count;
    }

    public boolean visit(NodeLabelUpdate update) throws IOException {
        this.writer.write(update);
        ++this.count;
        return false;
    }
}

