/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.tracer;

import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.tracing.LogCheckPointEvent;
import org.neo4j.kernel.impl.transaction.tracing.LogForceEvent;
import org.neo4j.kernel.impl.transaction.tracing.LogForceWaitEvent;

class CountingLogCheckPointEvent
implements LogCheckPointEvent {
    private final AtomicLong checkpointCounter = new AtomicLong();
    private final AtomicLong accumulatedCheckpointTotalTimeMillis = new AtomicLong();
    private final BiConsumer<LogPosition, LogPosition> logFileAppendConsumer;
    private volatile long lastCheckpointTimeMillis;

    CountingLogCheckPointEvent(BiConsumer<LogPosition, LogPosition> logFileAppendConsumer) {
        this.logFileAppendConsumer = logFileAppendConsumer;
    }

    @Override
    public void checkpointCompleted(long checkpointMillis) {
        this.checkpointCounter.incrementAndGet();
        this.accumulatedCheckpointTotalTimeMillis.addAndGet(checkpointMillis);
        this.lastCheckpointTimeMillis = checkpointMillis;
    }

    @Override
    public void close() {
    }

    @Override
    public void appendToLogFile(LogPosition positionBeforeCheckpoint, LogPosition positionAfterCheckpoint) {
        this.logFileAppendConsumer.accept(positionBeforeCheckpoint, positionAfterCheckpoint);
    }

    @Override
    public LogForceWaitEvent beginLogForceWait() {
        return LogForceWaitEvent.NULL;
    }

    @Override
    public LogForceEvent beginLogForce() {
        return LogForceEvent.NULL;
    }

    long numberOfCheckPoints() {
        return this.checkpointCounter.get();
    }

    long checkPointAccumulatedTotalTimeMillis() {
        return this.accumulatedCheckpointTotalTimeMillis.get();
    }

    long lastCheckpointTimeMillis() {
        return this.lastCheckpointTimeMillis;
    }
}

