/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.OpenOption;
import java.util.function.Consumer;
import org.neo4j.annotations.documented.ReporterFactory;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.index.internal.gbptree.GBPTreeConsistencyCheckVisitor;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.io.IOUtils;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.impl.index.schema.ConsistencyCheckable;
import org.neo4j.kernel.impl.index.schema.IndexFiles;
import org.neo4j.kernel.impl.index.schema.IndexLayout;
import org.neo4j.kernel.impl.index.schema.NativeIndexKey;
import org.neo4j.kernel.impl.index.schema.NativeIndexValue;

abstract class NativeIndex<KEY extends NativeIndexKey<KEY>, VALUE extends NativeIndexValue>
implements ConsistencyCheckable {
    final PageCache pageCache;
    final IndexFiles indexFiles;
    final IndexLayout<KEY, VALUE> layout;
    final FileSystemAbstraction fileSystem;
    final IndexDescriptor descriptor;
    private final IndexProvider.Monitor monitor;
    private final boolean readOnly;
    protected GBPTree<KEY, VALUE> tree;

    NativeIndex(PageCache pageCache, FileSystemAbstraction fs, IndexFiles indexFiles, IndexLayout<KEY, VALUE> layout, IndexProvider.Monitor monitor, IndexDescriptor descriptor, boolean readOnly) {
        this.pageCache = pageCache;
        this.indexFiles = indexFiles;
        this.layout = layout;
        this.fileSystem = fs;
        this.descriptor = descriptor;
        this.monitor = monitor;
        this.readOnly = readOnly;
    }

    void instantiateTree(RecoveryCleanupWorkCollector recoveryCleanupWorkCollector, Consumer<PageCursor> headerWriter) {
        this.ensureDirectoryExist();
        GBPTree.Monitor monitor = this.treeMonitor();
        File storeFile = this.indexFiles.getStoreFile();
        this.tree = new GBPTree(this.pageCache, storeFile, this.layout, 0, monitor, GBPTree.NO_HEADER_READER, headerWriter, recoveryCleanupWorkCollector, this.readOnly, new OpenOption[0]);
        this.afterTreeInstantiation(this.tree);
    }

    protected void afterTreeInstantiation(GBPTree<KEY, VALUE> tree) {
    }

    private GBPTree.Monitor treeMonitor() {
        return new NativeIndexTreeMonitor();
    }

    private void ensureDirectoryExist() {
        this.indexFiles.ensureDirectoryExist();
    }

    void closeTree() {
        IOUtils.closeAllUnchecked((AutoCloseable[])new GBPTree[]{this.tree});
        this.tree = null;
    }

    void assertOpen() {
        if (this.tree == null) {
            throw new IllegalStateException("Index has been closed");
        }
    }

    public boolean consistencyCheck(ReporterFactory reporterFactory) {
        return this.consistencyCheck((GBPTreeConsistencyCheckVisitor)reporterFactory.getClass(GBPTreeConsistencyCheckVisitor.class));
    }

    private boolean consistencyCheck(GBPTreeConsistencyCheckVisitor<KEY> visitor) {
        try {
            return this.tree.consistencyCheck(visitor);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private class NativeIndexTreeMonitor
    extends GBPTree.Monitor.Adaptor {
        private NativeIndexTreeMonitor() {
        }

        public void cleanupRegistered() {
            NativeIndex.this.monitor.recoveryCleanupRegistered(NativeIndex.this.indexFiles.getStoreFile(), NativeIndex.this.descriptor);
        }

        public void cleanupStarted() {
            NativeIndex.this.monitor.recoveryCleanupStarted(NativeIndex.this.indexFiles.getStoreFile(), NativeIndex.this.descriptor);
        }

        public void cleanupFinished(long numberOfPagesVisited, long numberOfTreeNodes, long numberOfCleanedCrashPointers, long durationMillis) {
            NativeIndex.this.monitor.recoveryCleanupFinished(NativeIndex.this.indexFiles.getStoreFile(), NativeIndex.this.descriptor, numberOfPagesVisited, numberOfTreeNodes, numberOfCleanedCrashPointers, durationMillis);
        }

        public void cleanupClosed() {
            NativeIndex.this.monitor.recoveryCleanupClosed(NativeIndex.this.indexFiles.getStoreFile(), NativeIndex.this.descriptor);
        }

        public void cleanupFailed(Throwable throwable) {
            NativeIndex.this.monitor.recoveryCleanupFailed(NativeIndex.this.indexFiles.getStoreFile(), NativeIndex.this.descriptor, throwable);
        }
    }
}

