/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.impl.iterator.ImmutableEmptyLongIterator;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.RelationshipTraversalCursor;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.kernel.impl.newapi.CursorPool;
import org.neo4j.kernel.impl.newapi.DefaultNodeCursor;
import org.neo4j.kernel.impl.newapi.DefaultRelationshipCursor;
import org.neo4j.kernel.impl.newapi.Read;
import org.neo4j.storageengine.api.RelationshipDirection;
import org.neo4j.storageengine.api.StorageRelationshipTraversalCursor;
import org.neo4j.storageengine.api.txstate.NodeState;

class DefaultRelationshipTraversalCursor
extends DefaultRelationshipCursor<StorageRelationshipTraversalCursor>
implements RelationshipTraversalCursor {
    private final CursorPool<DefaultRelationshipTraversalCursor> pool;
    private final DefaultNodeCursor nodeCursor;
    private LongIterator addedRelationships;
    private int type = -1;
    private RelationshipDirection direction;
    private boolean lazySelection;
    private boolean filterInitialized;
    private AccessMode mode;

    DefaultRelationshipTraversalCursor(CursorPool<DefaultRelationshipTraversalCursor> pool, StorageRelationshipTraversalCursor storeCursor, DefaultNodeCursor nodeCursor) {
        super(storeCursor);
        this.pool = pool;
        this.nodeCursor = nodeCursor;
    }

    void init(long nodeReference, long reference, boolean nodeIsDense, Read read) {
        ((StorageRelationshipTraversalCursor)this.storeCursor).init(nodeReference, reference, nodeIsDense);
        this.init(read);
        this.addedRelationships = ImmutableEmptyLongIterator.INSTANCE;
        this.filterInitialized = true;
    }

    void init(long nodeReference, long reference, int type, RelationshipDirection direction, boolean nodeIsDense, Read read) {
        this.type = type;
        this.direction = direction;
        this.lazySelection = (long)type == -1L;
        ((StorageRelationshipTraversalCursor)this.storeCursor).init(nodeReference, reference, type, direction, nodeIsDense);
        this.init(read);
        this.addedRelationships = ImmutableEmptyLongIterator.INSTANCE;
        this.filterInitialized = !this.lazySelection;
    }

    public RelationshipTraversalCursor.Position suspend() {
        throw new UnsupportedOperationException("not implemented");
    }

    public void resume(RelationshipTraversalCursor.Position position) {
        throw new UnsupportedOperationException("not implemented");
    }

    public void neighbour(NodeCursor cursor) {
        this.read.singleNode(this.neighbourNodeReference(), cursor);
    }

    public long neighbourNodeReference() {
        if (this.currentAddedInTx != -1L) {
            long originNodeReference = this.originNodeReference();
            if (this.txStateSourceNodeReference == originNodeReference) {
                return this.txStateTargetNodeReference;
            }
            if (this.txStateTargetNodeReference == originNodeReference) {
                return this.txStateSourceNodeReference;
            }
            throw new IllegalStateException(String.format("Relationship[%d] which was added in tx has an origin node [%d] which is neither source [%d] nor target [%d]", this.currentAddedInTx, originNodeReference, this.txStateSourceNodeReference, this.txStateTargetNodeReference));
        }
        return ((StorageRelationshipTraversalCursor)this.storeCursor).neighbourNodeReference();
    }

    public long originNodeReference() {
        return ((StorageRelationshipTraversalCursor)this.storeCursor).originNodeReference();
    }

    public boolean next() {
        boolean hasChanges;
        if (!this.filterInitialized) {
            hasChanges = this.hasChanges();
            this.setupFilterStateIfNeeded();
            if (this.filterInitialized && this.allowed() && (!hasChanges || !this.read.txState().relationshipIsDeletedInThisTx(this.relationshipReference()))) {
                if (this.tracer != null) {
                    this.tracer.onRelationship(this.relationshipReference());
                }
                return true;
            }
        } else {
            hasChanges = this.hasChanges();
        }
        if (hasChanges) {
            if (this.addedRelationships.hasNext()) {
                this.read.txState().relationshipVisit(this.addedRelationships.next(), this.relationshipTxStateDataVisitor);
                if (this.tracer != null) {
                    this.tracer.onRelationship(this.relationshipReference());
                }
                return true;
            }
            this.currentAddedInTx = -1L;
        }
        while (((StorageRelationshipTraversalCursor)this.storeCursor).next()) {
            boolean skip = hasChanges && this.read.txState().relationshipIsDeletedInThisTx(((StorageRelationshipTraversalCursor)this.storeCursor).entityReference());
            if (skip || !this.allowed()) continue;
            if (this.tracer != null) {
                this.tracer.onRelationship(this.relationshipReference());
            }
            return true;
        }
        return false;
    }

    private boolean allowed() {
        if (this.mode == null) {
            this.mode = this.read.ktx.securityContext().mode();
        }
        return this.mode.allowsTraverseRelType(((StorageRelationshipTraversalCursor)this.storeCursor).type()) && this.allowedToSeeEndNode(this.mode);
    }

    private boolean allowedToSeeEndNode(AccessMode mode) {
        if (mode.allowsTraverseAllLabels()) {
            return true;
        }
        this.read.singleNode(((StorageRelationshipTraversalCursor)this.storeCursor).neighbourNodeReference(), this.nodeCursor);
        return this.nodeCursor.next();
    }

    private void setupFilterStateIfNeeded() {
        if (!this.filterInitialized && this.lazySelection) {
            ((StorageRelationshipTraversalCursor)this.storeCursor).next();
            this.type = ((StorageRelationshipTraversalCursor)this.storeCursor).type();
            this.direction = RelationshipDirection.directionOfStrict((long)((StorageRelationshipTraversalCursor)this.storeCursor).originNodeReference(), (long)((StorageRelationshipTraversalCursor)this.storeCursor).sourceNodeReference(), (long)((StorageRelationshipTraversalCursor)this.storeCursor).targetNodeReference());
            this.filterInitialized = true;
        }
    }

    public void closeInternal() {
        if (!this.isClosed()) {
            this.read = null;
            this.type = -1;
            this.direction = null;
            this.filterInitialized = false;
            this.lazySelection = false;
            this.mode = null;
            ((StorageRelationshipTraversalCursor)this.storeCursor).close();
            this.pool.accept(this);
        }
    }

    @Override
    protected void collectAddedTxStateSnapshot() {
        this.setupFilterStateIfNeeded();
        NodeState nodeState = this.read.txState().getNodeState(((StorageRelationshipTraversalCursor)this.storeCursor).originNodeReference());
        this.addedRelationships = (long)this.type != -1L ? nodeState.getAddedRelationships(this.direction, this.type) : nodeState.getAddedRelationships();
    }

    public boolean isClosed() {
        return this.read == null;
    }

    public void release() {
        ((StorageRelationshipTraversalCursor)this.storeCursor).close();
        this.nodeCursor.close();
        this.nodeCursor.release();
    }

    public String toString() {
        if (this.isClosed()) {
            return "RelationshipTraversalCursor[closed state]";
        }
        return "RelationshipTraversalCursor[id=" + ((StorageRelationshipTraversalCursor)this.storeCursor).entityReference() + ", " + ((StorageRelationshipTraversalCursor)this.storeCursor).toString() + "]";
    }
}

