/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.eclipse.collections.impl.factory.primitive.LongSets;
import org.neo4j.collection.PrimitiveLongCollections;
import org.neo4j.internal.index.label.LabelScan;
import org.neo4j.internal.kernel.api.NodeLabelIndexCursor;
import org.neo4j.kernel.api.index.IndexProgressor;
import org.neo4j.kernel.api.txstate.TransactionState;
import org.neo4j.kernel.impl.newapi.BaseCursorScan;
import org.neo4j.kernel.impl.newapi.DefaultNodeLabelIndexCursor;
import org.neo4j.kernel.impl.newapi.Read;

class NodeLabelIndexCursorScan
extends BaseCursorScan<NodeLabelIndexCursor, LabelScan> {
    private final LongSet removed;
    private final int label;

    NodeLabelIndexCursorScan(Read read, int label, LabelScan labelScan) {
        super(labelScan, read, () -> read.txState().nodesWithLabelChanged(label).getAdded().toArray());
        this.label = label;
        if (this.hasChanges) {
            TransactionState txState = read.txState();
            this.removed = PrimitiveLongCollections.mergeToSet((LongIterable)txState.addedAndRemovedNodes().getRemoved(), (LongIterable)txState.nodesWithLabelChanged(label).getRemoved());
        } else {
            this.removed = LongSets.immutable.empty();
        }
    }

    @Override
    protected boolean scanStore(NodeLabelIndexCursor cursor, int sizeHint, LongIterator addedItems) {
        DefaultNodeLabelIndexCursor indexCursor = (DefaultNodeLabelIndexCursor)cursor;
        indexCursor.setRead(this.read);
        IndexProgressor indexProgressor = ((LabelScan)this.storageScan).initializeBatch(indexCursor.nodeLabelClient(), sizeHint);
        if (indexProgressor == IndexProgressor.EMPTY && !addedItems.hasNext()) {
            return false;
        }
        indexCursor.scan(indexProgressor, addedItems, this.removed, this.label);
        return true;
    }
}

