/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexOrder;
import org.neo4j.io.IOUtils;
import org.neo4j.kernel.api.index.IndexProgressor;
import org.neo4j.kernel.impl.newapi.Labels;
import org.neo4j.kernel.impl.newapi.Read;
import org.neo4j.values.storable.Value;

class NodeLabelSecurityFilter
implements IndexProgressor.EntityValueClient,
IndexProgressor {
    private final int[] properties;
    private final IndexProgressor.EntityValueClient target;
    private final NodeCursor node;
    private final Read read;
    private final AccessMode accessMode;
    private IndexProgressor progressor;

    NodeLabelSecurityFilter(int[] properties, IndexProgressor.EntityValueClient target, NodeCursor node, Read read, AccessMode accessMode) {
        this.properties = properties;
        this.target = target;
        this.node = node;
        this.read = read;
        this.accessMode = accessMode;
    }

    public boolean next() {
        return this.progressor.next();
    }

    public void close() {
        IOUtils.close(RuntimeException::new, (AutoCloseable[])new AutoCloseable[]{this.node, this.progressor});
    }

    public void initialize(IndexDescriptor descriptor, IndexProgressor progressor, IndexQuery[] query, IndexOrder indexOrder, boolean needsValues, boolean indexIncludesTransactionState) {
        this.progressor = progressor;
        this.target.initialize(descriptor, (IndexProgressor)this, query, indexOrder, needsValues, indexIncludesTransactionState);
    }

    public boolean acceptEntity(long reference, float score, Value ... values) {
        this.read.singleNode(reference, this.node);
        if (!this.node.next()) {
            return false;
        }
        boolean allowed = true;
        long[] labels = this.node.labelsIgnoringTxStateSetRemove().all();
        for (int prop : this.properties) {
            allowed &= this.accessMode.allowsReadNodeProperty(() -> Labels.from(labels), prop);
        }
        return allowed && this.target.acceptEntity(reference, score, values);
    }

    public boolean needsValues() {
        return this.target.needsValues();
    }
}

