/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexOrder;
import org.neo4j.io.IOUtils;
import org.neo4j.kernel.api.index.IndexProgressor;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

class NodeValueClientFilter
implements IndexProgressor.EntityValueClient,
IndexProgressor {
    private final IndexProgressor.EntityValueClient target;
    private final NodeCursor node;
    private final PropertyCursor property;
    private final IndexQuery[] filters;
    private final Read read;
    private IndexProgressor progressor;

    NodeValueClientFilter(IndexProgressor.EntityValueClient target, NodeCursor node, PropertyCursor property, Read read, IndexQuery ... filters) {
        this.target = target;
        this.node = node;
        this.property = property;
        this.filters = filters;
        this.read = read;
    }

    public void initialize(IndexDescriptor descriptor, IndexProgressor progressor, IndexQuery[] query, IndexOrder indexOrder, boolean needsValues, boolean indexIncludesTransactionState) {
        this.progressor = progressor;
        this.target.initialize(descriptor, (IndexProgressor)this, query, indexOrder, needsValues, indexIncludesTransactionState);
    }

    public boolean acceptEntity(long reference, float score, Value[] values) {
        int storeLookups = 0;
        if (values == null) {
            for (IndexQuery filter : this.filters) {
                if (filter == null) continue;
                ++storeLookups;
            }
        } else {
            for (int i = 0; i < this.filters.length; ++i) {
                IndexQuery filter = this.filters[i];
                if (filter == null) continue;
                if (values[i] == Values.NO_VALUE) {
                    ++storeLookups;
                    continue;
                }
                if (filter.acceptsValue(values[i])) continue;
                return false;
            }
        }
        if (storeLookups > 0 && !this.acceptByStoreFiltering(reference, storeLookups, values)) {
            return false;
        }
        return this.target.acceptEntity(reference, score, values);
    }

    private boolean acceptByStoreFiltering(long reference, int storeLookups, Value[] values) {
        this.read.singleNode(reference, this.node);
        if (!this.node.next()) {
            this.property.close();
            return false;
        }
        this.node.properties(this.property);
        while (storeLookups > 0 && this.property.next()) {
            for (int i = 0; i < this.filters.length; ++i) {
                IndexQuery filter = this.filters[i];
                if (filter == null || values != null && values[i] != Values.NO_VALUE || this.property.propertyKey() != filter.propertyKeyId()) continue;
                if (!filter.acceptsValueAt(this.property)) {
                    return false;
                }
                --storeLookups;
            }
        }
        return storeLookups == 0;
    }

    public boolean needsValues() {
        return true;
    }

    public boolean next() {
        return this.progressor.next();
    }

    public void close() {
        IOUtils.close(RuntimeException::new, (AutoCloseable[])new AutoCloseable[]{this.node, this.property, this.progressor});
    }
}

