/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.IOException;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryWriter;

public class TransactionLogWriter {
    private final LogEntryWriter writer;

    public TransactionLogWriter(LogEntryWriter writer) {
        this.writer = writer;
    }

    public int append(TransactionRepresentation transaction, long transactionId, int previousChecksum) throws IOException {
        this.writer.writeStartEntry(transaction.getTimeStarted(), transaction.getLatestCommittedTxWhenStarted(), previousChecksum, transaction.additionalHeader());
        this.writer.serialize(transaction);
        return this.writer.writeCommitEntry(transactionId, transaction.getTimeCommitted());
    }

    public void checkPoint(LogPosition logPosition) throws IOException {
        this.writer.writeCheckPointEntry(logPosition);
    }
}

