/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.util.Objects;
import org.neo4j.internal.helpers.collection.LruCache;
import org.neo4j.kernel.impl.transaction.log.LogPosition;

public class TransactionMetadataCache {
    private static final int DEFAULT_TRANSACTION_CACHE_SIZE = 100000;
    private final LruCache<Long, TransactionMetadata> txStartPositionCache;

    public TransactionMetadataCache() {
        this(100000);
    }

    public TransactionMetadataCache(int transactionCacheSize) {
        this.txStartPositionCache = new LruCache("Tx start position cache", transactionCacheSize);
    }

    public void clear() {
        this.txStartPositionCache.clear();
    }

    public TransactionMetadata getTransactionMetadata(long txId) {
        return (TransactionMetadata)this.txStartPositionCache.get((Object)txId);
    }

    public void cacheTransactionMetadata(long txId, LogPosition position, int checksum, long timeWritten) {
        if (position.getByteOffset() == -1L) {
            throw new RuntimeException("StartEntry.position is " + position);
        }
        TransactionMetadata result = new TransactionMetadata(position, checksum, timeWritten);
        this.txStartPositionCache.put((Object)txId, (Object)result);
    }

    public static class TransactionMetadata {
        private final LogPosition startPosition;
        private final int checksum;
        private final long timeWritten;

        public TransactionMetadata(LogPosition startPosition, int checksum, long timeWritten) {
            this.startPosition = startPosition;
            this.checksum = checksum;
            this.timeWritten = timeWritten;
        }

        public LogPosition getStartPosition() {
            return this.startPosition;
        }

        public int getChecksum() {
            return this.checksum;
        }

        public long getTimeWritten() {
            return this.timeWritten;
        }

        public String toString() {
            return "TransactionMetadata{, startPosition=" + this.startPosition + ", checksum=" + this.checksum + ", timeWritten=" + this.timeWritten + "}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TransactionMetadata that = (TransactionMetadata)o;
            return this.checksum == that.checksum && this.timeWritten == that.timeWritten && Objects.equals(this.startPosition, that.startPosition);
        }

        public int hashCode() {
            int result = this.startPosition.hashCode();
            result = 31 * result + this.checksum;
            result = 31 * result + (int)(this.timeWritten ^ this.timeWritten >>> 32);
            return result;
        }
    }
}

