/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.query;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.neo4j.kernel.api.query.ExecutingQueryStatus;
import org.neo4j.kernel.impl.locking.ActiveLock;
import org.neo4j.lock.LockType;
import org.neo4j.lock.ResourceType;

class WaitingOnLock
extends ExecutingQueryStatus {
    private final LockType lockType;
    private final ResourceType resourceType;
    private final long transactionId;
    private final long[] resourceIds;
    private final long startTimeNanos;

    WaitingOnLock(LockType lockType, ResourceType resourceType, long transactionId, long[] resourceIds, long startTimeNanos) {
        this.lockType = lockType;
        this.resourceType = resourceType;
        this.transactionId = transactionId;
        this.resourceIds = resourceIds;
        this.startTimeNanos = startTimeNanos;
    }

    @Override
    long waitTimeNanos(long currentTimeNanos) {
        return currentTimeNanos - this.startTimeNanos;
    }

    @Override
    Map<String, Object> toMap(long currentTimeNanos) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("lockMode", this.lockType.getDescription());
        map.put("waitTimeMillis", TimeUnit.NANOSECONDS.toMillis(this.waitTimeNanos(currentTimeNanos)));
        map.put("resourceType", this.resourceType.toString());
        map.put("resourceIds", this.resourceIds);
        map.put("transactionId", this.transactionId);
        return map;
    }

    @Override
    String name() {
        return "waiting";
    }

    @Override
    boolean isWaitingOnLocks() {
        return true;
    }

    @Override
    List<ActiveLock> waitingOnLocks() {
        ArrayList<ActiveLock> locks = new ArrayList<ActiveLock>(this.resourceIds.length);
        for (long resourceId : this.resourceIds) {
            locks.add(new ActiveLock(this.resourceType, this.lockType, this.transactionId, resourceId));
        }
        return locks;
    }
}

