/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BooleanSupplier;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.memory.DelegatingMemoryPool;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.LocalMemoryTracker;
import org.neo4j.memory.MemoryGroup;
import org.neo4j.memory.MemoryLimitExceededException;
import org.neo4j.memory.MemoryPool;
import org.neo4j.memory.MemoryPoolImpl;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.memory.ScopedMemoryPool;

public class TransactionMemoryPool
extends DelegatingMemoryPool
implements ScopedMemoryPool {
    private final ScopedMemoryPool delegate;
    private final Config config;
    private final BooleanSupplier openCheck;
    private final LogProvider logProvider;
    private final Set<LocalMemoryTracker> memoryTrackers = ConcurrentHashMap.newKeySet();
    private final LocalMemoryTracker transactionTracker;

    public TransactionMemoryPool(ScopedMemoryPool delegate, Config config, BooleanSupplier openCheck, LogProvider logProvider) {
        super((MemoryPool)new MemoryPoolImpl(delegate.totalSize(), true, GraphDatabaseSettings.memory_transaction_database_max_size.name()));
        this.delegate = delegate;
        this.config = config;
        this.openCheck = openCheck;
        this.logProvider = logProvider;
        this.transactionTracker = this.createMemoryTracer();
    }

    public MemoryGroup group() {
        return this.delegate.group();
    }

    public void close() {
        this.reset();
    }

    public LocalMemoryTracker getTransactionTracker() {
        return this.transactionTracker;
    }

    public MemoryTracker getPoolMemoryTracker() {
        if (((Boolean)this.config.get(GraphDatabaseSettings.memory_tracking)).booleanValue()) {
            LocalMemoryTracker memoryTracker = this.createMemoryTracer();
            this.memoryTrackers.add(memoryTracker);
            return memoryTracker;
        }
        return EmptyMemoryTracker.INSTANCE;
    }

    public void reserveHeap(long bytes) {
        this.delegate.reserveHeap(bytes);
        try {
            super.reserveHeap(bytes);
        }
        catch (MemoryLimitExceededException e) {
            this.delegate.releaseHeap(bytes);
            throw e;
        }
    }

    public void releaseHeap(long bytes) {
        super.releaseHeap(bytes);
        this.delegate.releaseHeap(bytes);
    }

    public void reserveNative(long bytes) {
        this.delegate.reserveNative(bytes);
        try {
            super.reserveNative(bytes);
        }
        catch (MemoryLimitExceededException e) {
            this.delegate.releaseNative(bytes);
            throw e;
        }
    }

    public void releaseNative(long bytes) {
        super.releaseNative(bytes);
        this.delegate.releaseNative(bytes);
    }

    private LocalMemoryTracker createMemoryTracer() {
        return new LocalMemoryTracker((MemoryPool)this, 0L, ((Long)this.config.get(GraphDatabaseInternalSettings.initial_transaction_heap_grab_size)).longValue(), GraphDatabaseSettings.memory_transaction_max_size.name(), this.openCheck, TransactionMemoryPool.memoryLeakLogger(this.logProvider.getLog(((Object)((Object)this)).getClass())));
    }

    private static LocalMemoryTracker.Monitor memoryLeakLogger(Log log) {
        return leakedNativeMemoryBytes -> log.warn("Potential direct memory leak. Expecting all allocated direct memory to be released, but still has " + leakedNativeMemoryBytes);
    }

    public void setLimit(long transactionHeapBytesLimit) {
        this.setSize(transactionHeapBytesLimit);
    }

    public void reset() {
        this.transactionTracker.reset();
        if (!this.memoryTrackers.isEmpty()) {
            for (LocalMemoryTracker memoryTracker : this.memoryTrackers) {
                memoryTracker.checkAllocatedNativeBytes();
            }
            this.releaseHeap(this.usedHeap());
            this.memoryTrackers.clear();
        }
        assert (this.usedNative() == 0L) : "Potential direct memory leak. Expecting all allocated direct memory to be released, but still has " + this.usedNative();
        assert (this.usedHeap() == 0L) : "Heap memory leak. Expecting all allocated memory to be released, but still has " + this.usedHeap();
    }
}

