/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.commit;

import java.util.List;
import org.neo4j.exceptions.KernelException;
import org.neo4j.graphdb.Resource;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.KernelVersionProvider;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.api.LeaseClient;
import org.neo4j.kernel.impl.api.TransactionCommitProcess;
import org.neo4j.kernel.impl.api.TransactionToApply;
import org.neo4j.kernel.impl.api.commit.TransactionCommitter;
import org.neo4j.kernel.impl.api.txid.TransactionIdGenerator;
import org.neo4j.kernel.impl.transaction.log.CompleteTransaction;
import org.neo4j.kernel.impl.transaction.log.TransactionCommitmentFactory;
import org.neo4j.kernel.impl.transaction.tracing.TransactionRollbackEvent;
import org.neo4j.kernel.impl.transaction.tracing.TransactionWriteEvent;
import org.neo4j.lock.LockTracer;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.StorageCommand;
import org.neo4j.storageengine.api.TransactionApplicationMode;
import org.neo4j.storageengine.api.cursor.StoreCursors;
import org.neo4j.storageengine.api.txstate.validation.TransactionValidator;

public final class DefaultCommitter
implements TransactionCommitter {
    private final KernelTransactionImplementation ktx;
    private final TransactionCommitmentFactory commitmentFactory;
    private final KernelVersionProvider kernelVersionProvider;
    private final TransactionCommitProcess commitProcess;
    private final StoreCursors transactionalCursors;
    private final TransactionIdGenerator transactionIdGenerator;
    private final TransactionValidator transactionValidator;

    public DefaultCommitter(KernelTransactionImplementation ktx, TransactionCommitmentFactory commitmentFactory, KernelVersionProvider kernelVersionProvider, StoreCursors transactionalCursors, TransactionIdGenerator transactionIdGenerator, TransactionCommitProcess commitProcess, TransactionValidator transactionValidator) {
        this.ktx = ktx;
        this.commitmentFactory = commitmentFactory;
        this.kernelVersionProvider = kernelVersionProvider;
        this.commitProcess = commitProcess;
        this.transactionalCursors = transactionalCursors;
        this.transactionIdGenerator = transactionIdGenerator;
        this.transactionValidator = transactionValidator;
    }

    @Override
    public long commit(TransactionWriteEvent transactionWriteEvent, LeaseClient leaseClient, CursorContext cursorContext, MemoryTracker memoryTracker, KernelTransaction.KernelTransactionMonitor kernelTransactionMonitor, LockTracer lockTracer, long commitTime, long startTimeMillis, long lastTransactionIdWhenStarted, boolean commit) throws KernelException {
        List<StorageCommand> extractedCommands = this.ktx.extractCommands(memoryTracker);
        if (!extractedCommands.isEmpty()) {
            try (Resource guards = this.transactionValidator.validate(extractedCommands, this.ktx.getTransactionSequenceNumber(), cursorContext, leaseClient, lockTracer);){
                CompleteTransaction transactionRepresentation = new CompleteTransaction(extractedCommands, -1L, startTimeMillis, lastTransactionIdWhenStarted, commitTime, leaseClient.leaseId(), this.kernelVersionProvider.kernelVersion(), this.ktx.securityContext().subject().userSubject());
                TransactionToApply batch = new TransactionToApply(transactionRepresentation, cursorContext, this.transactionalCursors, this.commitmentFactory.newCommitment(), this.transactionIdGenerator);
                kernelTransactionMonitor.beforeApply();
                long l = this.commitProcess.commit(batch, transactionWriteEvent, TransactionApplicationMode.INTERNAL);
                return l;
            }
        }
        return 0L;
    }

    @Override
    public void rollback(TransactionRollbackEvent rollbackEvent) {
    }
}

