/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.coreapi.schema;

import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.graphdb.schema.IndexType;
import org.neo4j.graphdb.schema.PropertyType;
import org.neo4j.internal.schema.IndexConfig;
import org.neo4j.internal.schema.SchemaValueType;
import org.neo4j.internal.schema.constraints.PropertyTypeSet;
import org.neo4j.kernel.impl.coreapi.schema.InternalSchemaActions;

abstract class AbstractConstraintCreator {
    protected final InternalSchemaActions actions;
    protected final String name;
    protected final IndexType indexType;
    protected final IndexConfig indexConfig;

    AbstractConstraintCreator(InternalSchemaActions actions, String name, IndexType indexType, IndexConfig indexConfig) {
        this.actions = actions;
        this.name = name;
        this.indexType = indexType;
        this.indexConfig = indexConfig;
    }

    public ConstraintDefinition create() {
        this.assertInUnterminatedTransaction();
        throw new IllegalStateException("No constraint assertions specified");
    }

    protected final void assertInUnterminatedTransaction() {
        this.actions.assertInOpenTransaction();
    }

    protected PropertyTypeSet validatePropertyTypes(PropertyType[] propertyType) {
        if (propertyType.length == 0) {
            throw new IllegalArgumentException("A property type must be supplied.");
        }
        if (propertyType.length > 1) {
            throw new IllegalArgumentException("Multiple property types are not supported.");
        }
        return PropertyTypeSet.of((SchemaValueType[])new SchemaValueType[]{SchemaValueType.fromPublicApi((PropertyType)propertyType[0])});
    }
}

