/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.coreapi.schema;

import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.schema.ConstraintType;
import org.neo4j.graphdb.schema.PropertyType;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.SchemaValueType;
import org.neo4j.internal.schema.constraints.PropertyTypeSet;
import org.neo4j.kernel.impl.coreapi.schema.InternalSchemaActions;
import org.neo4j.kernel.impl.coreapi.schema.RelationshipConstraintDefinition;

public class RelationshipPropertyTypeConstraintDefinition
extends RelationshipConstraintDefinition {
    public RelationshipPropertyTypeConstraintDefinition(InternalSchemaActions actions, ConstraintDescriptor constraint, RelationshipType relationshipType, String propertyKey) {
        super(actions, constraint, relationshipType, propertyKey);
    }

    public ConstraintType getConstraintType() {
        this.assertInUnterminatedTransaction();
        return ConstraintType.RELATIONSHIP_PROPERTY_TYPE;
    }

    @Override
    public String toString() {
        return String.format("FOR ()-[%s:%s]-() REQUIRE %s IS :: %s", this.relationshipType.name().toLowerCase(), this.relationshipType.name(), this.propertyText(this.relationshipType.name().toLowerCase()), this.constraint.asPropertyTypeConstraint().propertyType().userDescription());
    }

    @Override
    public PropertyType[] getPropertyType() {
        this.assertInUnterminatedTransaction();
        PropertyTypeSet propertyTypeSet = this.constraint.asPropertyTypeConstraint().propertyType();
        return (PropertyType[])propertyTypeSet.stream().map(SchemaValueType::toPublicApi).toArray(PropertyType[]::new);
    }
}

