/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import org.neo4j.internal.kernel.api.KernelReadTracer;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.RelationshipTypeIndexCursor;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.kernel.impl.newapi.CursorPool;
import org.neo4j.kernel.impl.newapi.DefaultEntityTokenIndexCursor;

public abstract class DefaultRelationshipTypeIndexCursor
extends DefaultEntityTokenIndexCursor<DefaultRelationshipTypeIndexCursor>
implements RelationshipTypeIndexCursor {
    protected DefaultRelationshipTypeIndexCursor(CursorPool<DefaultRelationshipTypeIndexCursor> pool) {
        super(pool);
    }

    public final int type() {
        return this.tokenId;
    }

    public final float score() {
        return Float.NaN;
    }

    public long relationshipReference() {
        return this.entityReference();
    }

    public void source(NodeCursor cursor) {
        this.read.singleNode(this.sourceNodeReference(), cursor);
    }

    public void target(NodeCursor cursor) {
        this.read.singleNode(this.targetNodeReference(), cursor);
    }

    @Override
    protected final boolean allowedToSeeAllEntitiesWithToken(AccessMode accessMode, int token) {
        return accessMode.allowsTraverseRelType(token) && accessMode.allowsTraverseAllLabels();
    }

    @Override
    protected void traceNext(KernelReadTracer tracer, long entity) {
        tracer.onRelationship(entity);
    }

    @Override
    protected final void traceScan(KernelReadTracer tracer, int token) {
        tracer.onRelationshipTypeScan(token);
    }
}

