/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.reverse;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.neo4j.kernel.impl.transaction.CommittedCommandBatch;
import org.neo4j.kernel.impl.transaction.log.CommandBatchCursor;
import org.neo4j.kernel.impl.transaction.log.LogPosition;

public class EagerlyReversedCommandBatchCursor
implements CommandBatchCursor {
    private final List<CommittedCommandBatch> batches = new ArrayList<CommittedCommandBatch>();
    private final CommandBatchCursor cursor;
    private int indexToReturn;

    public EagerlyReversedCommandBatchCursor(CommandBatchCursor cursor) throws IOException {
        this.cursor = cursor;
        while (cursor.next()) {
            this.batches.add((CommittedCommandBatch)cursor.get());
        }
        this.indexToReturn = this.batches.size();
    }

    public boolean next() {
        if (this.indexToReturn > 0) {
            --this.indexToReturn;
            return true;
        }
        return false;
    }

    public void close() throws IOException {
        this.cursor.close();
    }

    public CommittedCommandBatch get() {
        return this.batches.get(this.indexToReturn);
    }

    @Override
    public LogPosition position() {
        throw new UnsupportedOperationException("Should not be called");
    }

    public static CommandBatchCursor eagerlyReverse(CommandBatchCursor cursor) throws IOException {
        return new EagerlyReversedCommandBatchCursor(cursor);
    }
}

