/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.SearcherFactory;
import org.apache.lucene.search.SearcherManager;
import org.apache.lucene.search.TermQuery;
import org.neo4j.helpers.ThisShouldNotHappenError;
import org.neo4j.kernel.api.exceptions.KernelException;
import org.neo4j.kernel.api.impl.index.DirectoryFactory;
import org.neo4j.kernel.api.impl.index.IndexWriterStatus;
import org.neo4j.kernel.api.impl.index.LuceneDocumentStructure;
import org.neo4j.kernel.api.impl.index.LuceneIndexPopulator;
import org.neo4j.kernel.api.impl.index.LuceneIndexWriterFactory;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.api.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.NodePropertyUpdate;
import org.neo4j.kernel.api.index.PreexistingIndexEntryConflictException;
import org.neo4j.kernel.api.index.PropertyAccessor;
import org.neo4j.kernel.api.index.util.FailureStorage;
import org.neo4j.kernel.api.properties.Property;

class DeferredConstraintVerificationUniqueLuceneIndexPopulator
extends LuceneIndexPopulator {
    private final IndexDescriptor descriptor;
    private SearcherManager searcherManager;

    DeferredConstraintVerificationUniqueLuceneIndexPopulator(LuceneDocumentStructure documentStructure, LuceneIndexWriterFactory indexWriterFactory, IndexWriterStatus writerStatus, DirectoryFactory dirFactory, File dirFile, FailureStorage failureStorage, long indexId, IndexDescriptor descriptor) {
        super(documentStructure, indexWriterFactory, writerStatus, dirFactory, dirFile, failureStorage, indexId);
        this.descriptor = descriptor;
    }

    @Override
    public void create() throws IOException {
        super.create();
        this.searcherManager = new SearcherManager(this.writer, true, new SearcherFactory());
    }

    @Override
    public void drop() {
    }

    @Override
    protected void flush() throws IOException {
    }

    public void add(long nodeId, Object propertyValue) throws IndexEntryConflictException, IOException {
        this.writer.addDocument(this.documentStructure.newDocumentRepresentingProperty(nodeId, propertyValue));
    }

    public void verifyDeferredConstraints(PropertyAccessor accessor) throws IndexEntryConflictException, IOException {
        this.searcherManager.maybeRefresh();
        IndexSearcher searcher = (IndexSearcher)this.searcherManager.acquire();
        try {
            DuplicateCheckingCollector collector = this.duplicateCheckingCollector(accessor);
            TermEnum terms = searcher.getIndexReader().terms();
            while (terms.next()) {
                Term term = terms.term();
                if ("id".equals(term.field()) || terms.docFreq() <= 1) continue;
                collector.reset();
                searcher.search((Query)new TermQuery(term), (Collector)collector);
            }
        }
        catch (IOException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IndexEntryConflictException) {
                throw (IndexEntryConflictException)cause;
            }
            throw e;
        }
        finally {
            this.searcherManager.release((Object)searcher);
        }
    }

    private DuplicateCheckingCollector duplicateCheckingCollector(PropertyAccessor accessor) {
        return new DuplicateCheckingCollector(accessor, this.documentStructure, this.descriptor.getPropertyKeyId());
    }

    public IndexUpdater newPopulatingUpdater(final PropertyAccessor accessor) throws IOException {
        return new IndexUpdater(){
            List<Object> updatedPropertyValues = new ArrayList<Object>();

            public void process(NodePropertyUpdate update) throws IOException, IndexEntryConflictException {
                long nodeId = update.getNodeId();
                switch (update.getUpdateMode()) {
                    case ADDED: 
                    case CHANGED: {
                        DeferredConstraintVerificationUniqueLuceneIndexPopulator.this.writer.updateDocument(DeferredConstraintVerificationUniqueLuceneIndexPopulator.this.documentStructure.newQueryForChangeOrRemove(nodeId), DeferredConstraintVerificationUniqueLuceneIndexPopulator.this.documentStructure.newDocumentRepresentingProperty(nodeId, update.getValueAfter()));
                        this.updatedPropertyValues.add(update.getValueAfter());
                        break;
                    }
                    case REMOVED: {
                        DeferredConstraintVerificationUniqueLuceneIndexPopulator.this.writer.deleteDocuments(DeferredConstraintVerificationUniqueLuceneIndexPopulator.this.documentStructure.newQueryForChangeOrRemove(nodeId));
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unknown update mode " + update.getUpdateMode());
                    }
                }
            }

            public void close() throws IOException, IndexEntryConflictException {
                DeferredConstraintVerificationUniqueLuceneIndexPopulator.this.searcherManager.maybeRefresh();
                IndexSearcher searcher = (IndexSearcher)DeferredConstraintVerificationUniqueLuceneIndexPopulator.this.searcherManager.acquire();
                try {
                    DuplicateCheckingCollector collector = DeferredConstraintVerificationUniqueLuceneIndexPopulator.this.duplicateCheckingCollector(accessor);
                    for (Object propertyValue : this.updatedPropertyValues) {
                        collector.reset();
                        Query query = DeferredConstraintVerificationUniqueLuceneIndexPopulator.this.documentStructure.newQuery(propertyValue);
                        searcher.search(query, (Collector)collector);
                    }
                }
                catch (IOException e) {
                    Throwable cause = e.getCause();
                    if (cause instanceof IndexEntryConflictException) {
                        throw (IndexEntryConflictException)cause;
                    }
                    throw e;
                }
                finally {
                    DeferredConstraintVerificationUniqueLuceneIndexPopulator.this.searcherManager.release((Object)searcher);
                }
            }

            public void remove(Iterable<Long> nodeIds) {
                throw new UnsupportedOperationException("should not remove() from populating index");
            }
        };
    }

    private static class EntrySet {
        static final int INCREMENT = 100;
        Object[] value = new Object[100];
        long[] nodeId = new long[100];
        EntrySet next;

        private EntrySet() {
        }

        public void reset() {
            EntrySet current = this;
            do {
                for (int i = 0; i < 100; ++i) {
                    current.value[i] = null;
                    current.nodeId[i] = -1L;
                }
            } while ((current = this.next) != null);
        }
    }

    private static class DuplicateCheckingCollector
    extends Collector {
        private final PropertyAccessor accessor;
        private final LuceneDocumentStructure documentStructure;
        private final int propertyKeyId;
        private final EntrySet actualValues;
        private IndexReader reader;
        private int docBase;

        public DuplicateCheckingCollector(PropertyAccessor accessor, LuceneDocumentStructure documentStructure, int propertyKeyId) {
            this.accessor = accessor;
            this.documentStructure = documentStructure;
            this.propertyKeyId = propertyKeyId;
            this.actualValues = new EntrySet();
        }

        public void setScorer(Scorer scorer) throws IOException {
        }

        public void collect(int doc) throws IOException {
            try {
                this.doCollect(doc);
            }
            catch (KernelException e) {
                throw new ThisShouldNotHappenError("Chris", "Indexed node should exist and have the indexed property.", (Throwable)e);
            }
            catch (PreexistingIndexEntryConflictException e) {
                throw new IOException(e);
            }
        }

        private void doCollect(int doc) throws IOException, KernelException, PreexistingIndexEntryConflictException {
            Document document = this.reader.document(doc);
            long nodeId = this.documentStructure.getNodeId(document);
            Property property = this.accessor.getProperty(nodeId, this.propertyKeyId);
            EntrySet current = this.actualValues;
            block0: do {
                for (int i = 0; i < 100; ++i) {
                    Object value = current.value[i];
                    if (current.nodeId[i] == -1L) {
                        current.value[i] = property.value();
                        current.nodeId[i] = nodeId;
                        if (i != 99) break block0;
                        current.next = new EntrySet();
                        break block0;
                    }
                    if (!property.valueEquals(value)) continue;
                    throw new PreexistingIndexEntryConflictException(value, current.nodeId[i], nodeId);
                }
            } while ((current = current.next) != null);
        }

        public void setNextReader(IndexReader reader, int docBase) throws IOException {
            this.reader = reader;
            this.docBase = docBase;
        }

        public boolean acceptsDocsOutOfOrder() {
            return true;
        }

        public void reset() {
            this.actualValues.reset();
        }
    }
}

