/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index;

import java.io.IOException;
import java.util.Iterator;
import org.apache.lucene.document.Document;
import org.neo4j.kernel.api.direct.BoundedIterable;
import org.neo4j.kernel.api.impl.index.LuceneDocumentStructure;

public class LuceneAllEntriesIndexAccessorReader
implements BoundedIterable<Long> {
    private final BoundedIterable<Document> documents;
    private final LuceneDocumentStructure documentLogic;

    public LuceneAllEntriesIndexAccessorReader(BoundedIterable<Document> documents, LuceneDocumentStructure documentLogic) {
        this.documents = documents;
        this.documentLogic = documentLogic;
    }

    public long maxCount() {
        return this.documents.maxCount();
    }

    public Iterator<Long> iterator() {
        final Iterator iterator = this.documents.iterator();
        return new Iterator<Long>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public Long next() {
                return LuceneAllEntriesIndexAccessorReader.this.parse((Document)iterator.next());
            }

            @Override
            public void remove() {
                iterator.remove();
            }
        };
    }

    public void close() throws IOException {
        this.documents.close();
    }

    private Long parse(Document document) {
        return this.documentLogic.getNodeId(document);
    }
}

