/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.impl.lucene;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.index.IndexCommandFactory;
import org.neo4j.graphdb.index.IndexImplementation;
import org.neo4j.graphdb.index.LegacyIndexProviderTransaction;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.index.impl.lucene.IndexType;
import org.neo4j.index.impl.lucene.LuceneCommandApplier;
import org.neo4j.index.impl.lucene.LuceneDataSource;
import org.neo4j.index.impl.lucene.LuceneLegacyIndexTransaction;
import org.neo4j.kernel.impl.transaction.command.NeoCommandHandler;

public class LuceneIndexImplementation
implements IndexImplementation {
    static final String KEY_TYPE = "type";
    static final String KEY_ANALYZER = "analyzer";
    static final String KEY_TO_LOWER_CASE = "to_lower_case";
    static final String KEY_SIMILARITY = "similarity";
    public static final String SERVICE_NAME = "lucene";
    public static final Map<String, String> EXACT_CONFIG = Collections.unmodifiableMap(MapUtil.stringMap((String[])new String[]{"provider", "lucene", "type", "exact"}));
    public static final Map<String, String> FULLTEXT_CONFIG = Collections.unmodifiableMap(MapUtil.stringMap((String[])new String[]{"provider", "lucene", "type", "fulltext", "to_lower_case", "true"}));
    public static final int DEFAULT_LAZY_THRESHOLD = 100;
    private final LuceneDataSource dataSource;
    final int lazynessThreshold;

    public LuceneIndexImplementation(LuceneDataSource dataSource) {
        this.dataSource = dataSource;
        this.lazynessThreshold = 100;
    }

    public LegacyIndexProviderTransaction newTransaction(IndexCommandFactory commandFactory) {
        return new LuceneLegacyIndexTransaction(this.dataSource, commandFactory);
    }

    public Map<String, String> fillInDefaults(Map<String, String> source) {
        HashMap<String, String> result = source != null ? new HashMap<String, String>(source) : new HashMap();
        String analyzer = (String)result.get(KEY_ANALYZER);
        if (analyzer == null) {
            String type = (String)result.get(KEY_TYPE);
            if (type == null) {
                type = "exact";
                result.put(KEY_TYPE, type);
            }
            if (type.equals("fulltext") && !result.containsKey(KEY_TO_LOWER_CASE)) {
                result.put(KEY_TO_LOWER_CASE, "true");
            }
        }
        IndexType.getIndexType(result);
        return result;
    }

    public boolean configMatches(Map<String, String> storedConfig, Map<String, String> config) {
        return this.match(storedConfig, config, KEY_TYPE, null) && this.match(storedConfig, config, KEY_TO_LOWER_CASE, "true") && this.match(storedConfig, config, KEY_ANALYZER, null) && this.match(storedConfig, config, KEY_SIMILARITY, null);
    }

    private boolean match(Map<String, String> storedConfig, Map<String, String> config, String key, String defaultValue) {
        String value1 = storedConfig.get(key);
        String value2 = config.get(key);
        if (value1 == null || value2 == null) {
            if (value1 == value2) {
                return true;
            }
            if (defaultValue != null) {
                value1 = value1 != null ? value1 : defaultValue;
                value2 = value2 != null ? value2 : defaultValue;
                return value1.equals(value2);
            }
        } else {
            return value1.equals(value2);
        }
        return false;
    }

    public NeoCommandHandler newApplier(boolean recovery) {
        return new LuceneCommandApplier(this.dataSource, recovery);
    }

    public ResourceIterator<File> listStoreFiles() throws IOException {
        return this.dataSource.listStoreFiles();
    }

    public void force() {
        this.dataSource.force();
    }
}

