/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.lucene;

import java.io.File;
import java.io.IOException;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.api.exceptions.index.IndexCapacityExceededException;
import org.neo4j.kernel.api.impl.index.DirectoryFactory;
import org.neo4j.kernel.api.impl.index.IndexWriterFactories;
import org.neo4j.kernel.api.impl.index.LuceneLabelScanStore;
import org.neo4j.kernel.api.impl.index.NodeRangeDocumentLabelScanStorageStrategy;
import org.neo4j.kernel.api.labelscan.LabelScanStore;
import org.neo4j.kernel.impl.api.scan.LabelScanStoreProvider;
import org.neo4j.kernel.impl.store.NeoStore;
import org.neo4j.kernel.impl.transaction.state.NeoStoreProvider;
import org.neo4j.kernel.impl.transaction.state.SimpleNeoStoreProvider;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.logging.Logging;
import org.neo4j.kernel.logging.SingleLoggingService;

public class LuceneLabelScanStoreBuilder {
    private final String storeDir;
    private final NeoStoreProvider neoStoreProvider;
    private final FileSystemAbstraction fileSystem;
    private final SingleLoggingService logger;
    private LuceneLabelScanStore labelScanStore = null;

    public LuceneLabelScanStoreBuilder(String storeDir, NeoStore neoStore, FileSystemAbstraction fileSystem, StringLogger logger) {
        this.storeDir = storeDir;
        this.neoStoreProvider = new SimpleNeoStoreProvider(neoStore);
        this.fileSystem = fileSystem;
        this.logger = new SingleLoggingService(logger);
    }

    public LabelScanStore build() {
        if (null == this.labelScanStore) {
            this.labelScanStore = new LuceneLabelScanStore(new NodeRangeDocumentLabelScanStorageStrategy(), DirectoryFactory.PERSISTENT, new File(new File(new File(this.storeDir, "schema"), "label"), "lucene"), this.fileSystem, IndexWriterFactories.tracking(), LabelScanStoreProvider.fullStoreLabelUpdateStream((NeoStoreProvider)this.neoStoreProvider), LuceneLabelScanStore.loggerMonitor((Logging)this.logger));
            try {
                this.labelScanStore.init();
                this.labelScanStore.start();
            }
            catch (IOException | IndexCapacityExceededException e) {
                throw new RuntimeException(e);
            }
        }
        return this.labelScanStore;
    }
}

