/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index;

import java.io.IOException;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.Term;
import org.apache.lucene.store.Directory;
import org.neo4j.kernel.api.exceptions.index.IndexCapacityExceededException;
import org.neo4j.kernel.api.impl.index.LuceneIndexWriter;

class TrackingLuceneIndexWriter
extends LuceneIndexWriter {
    TrackingLuceneIndexWriter(Directory directory, IndexWriterConfig config) throws IOException {
        super(directory, config);
    }

    @Override
    public void addDocument(Document document) throws IOException, IndexCapacityExceededException {
        this.checkMaxDoc();
        super.addDocument(document);
    }

    @Override
    public void updateDocument(Term term, Document document) throws IOException, IndexCapacityExceededException {
        this.checkMaxDoc();
        super.updateDocument(term, document);
    }

    private void checkMaxDoc() throws IOException, IndexCapacityExceededException {
        long limit;
        int currentMaxDoc = this.writer.maxDoc();
        if ((long)currentMaxDoc >= (limit = this.maxDocLimit())) {
            throw new IndexCapacityExceededException((long)currentMaxDoc, limit);
        }
    }
}

