/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.SearcherManager;
import org.apache.lucene.search.TopDocs;
import org.neo4j.collection.primitive.PrimitiveLongSet;
import org.neo4j.kernel.api.exceptions.index.IndexCapacityExceededException;
import org.neo4j.kernel.api.impl.index.DirectoryFactory;
import org.neo4j.kernel.api.impl.index.IndexWriterFactory;
import org.neo4j.kernel.api.impl.index.IndexWriterStatus;
import org.neo4j.kernel.api.impl.index.LuceneDocumentStructure;
import org.neo4j.kernel.api.impl.index.LuceneIndexPopulator;
import org.neo4j.kernel.api.impl.index.LuceneIndexWriter;
import org.neo4j.kernel.api.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.NodePropertyUpdate;
import org.neo4j.kernel.api.index.PreexistingIndexEntryConflictException;
import org.neo4j.kernel.api.index.PropertyAccessor;
import org.neo4j.kernel.api.index.Reservation;
import org.neo4j.kernel.api.index.util.FailureStorage;
import org.neo4j.register.Register;

@Deprecated
class UniqueLuceneIndexPopulator
extends LuceneIndexPopulator {
    private static final float LOAD_FACTOR = 0.75f;
    private final int batchSize;
    private SearcherManager searcherManager;
    private Map<Object, Long> currentBatch = this.newBatchMap();

    UniqueLuceneIndexPopulator(int batchSize, LuceneDocumentStructure documentStructure, IndexWriterFactory<LuceneIndexWriter> indexWriterFactory, IndexWriterStatus writerStatus, DirectoryFactory dirFactory, File dirFile, FailureStorage failureStorage, long indexId) {
        super(documentStructure, indexWriterFactory, writerStatus, dirFactory, dirFile, failureStorage, indexId);
        this.batchSize = batchSize;
    }

    private HashMap<Object, Long> newBatchMap() {
        return new HashMap<Object, Long>((int)((float)this.batchSize / 0.75f), 0.75f);
    }

    @Override
    public void create() throws IOException {
        super.create();
        this.searcherManager = this.writer.createSearcherManager();
    }

    @Override
    public void drop() {
        this.currentBatch.clear();
    }

    @Override
    protected void flush() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(long nodeId, Object propertyValue) throws IndexEntryConflictException, IOException, IndexCapacityExceededException {
        Long previousEntry = this.currentBatch.get(propertyValue);
        if (previousEntry == null) {
            IndexSearcher searcher = (IndexSearcher)this.searcherManager.acquire();
            try {
                TopDocs docs = searcher.search(this.documentStructure.newQuery(propertyValue), 1);
                if (docs.totalHits > 0) {
                    Document doc = searcher.getIndexReader().document(docs.scoreDocs[0].doc);
                    previousEntry = this.documentStructure.getNodeId(doc);
                }
            }
            finally {
                this.searcherManager.release((Object)searcher);
            }
        }
        if (previousEntry != null) {
            if (previousEntry != nodeId) {
                throw new PreexistingIndexEntryConflictException(propertyValue, previousEntry.longValue(), nodeId);
            }
        } else {
            this.currentBatch.put(propertyValue, nodeId);
            Fieldable encodedValue = this.documentStructure.encodeAsFieldable(propertyValue);
            this.writer.addDocument(this.documentStructure.newDocumentRepresentingProperty(nodeId, encodedValue));
            if (this.currentBatch.size() >= this.batchSize) {
                this.startNewBatch();
            }
        }
    }

    public void verifyDeferredConstraints(PropertyAccessor accessor) throws IndexEntryConflictException, IOException {
    }

    public IndexUpdater newPopulatingUpdater(PropertyAccessor propertyAccessor) throws IOException {
        return new IndexUpdater(){

            public Reservation validate(Iterable<NodePropertyUpdate> updates) throws IOException {
                return Reservation.EMPTY;
            }

            public void process(NodePropertyUpdate update) throws IOException, IndexEntryConflictException, IndexCapacityExceededException {
                UniqueLuceneIndexPopulator.this.add(update.getNodeId(), update.getValueAfter());
            }

            public void close() throws IOException, IndexEntryConflictException {
            }

            public void remove(PrimitiveLongSet nodeIds) {
                throw new UnsupportedOperationException("should not remove() from populating index");
            }
        };
    }

    public long sampleResult(Register.DoubleLong.Out result) {
        throw new UnsupportedOperationException();
    }

    private void startNewBatch() throws IOException {
        this.searcherManager.maybeRefresh();
        this.currentBatch = this.newBatchMap();
    }
}

