/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index;

import java.io.File;
import org.neo4j.kernel.api.impl.index.DirectoryFactory;
import org.neo4j.kernel.api.impl.index.IndexWriterFactories;
import org.neo4j.kernel.api.impl.index.LuceneKernelExtensions;
import org.neo4j.kernel.api.impl.index.LuceneLabelScanStore;
import org.neo4j.kernel.api.impl.index.NodeRangeDocumentLabelScanStorageStrategy;
import org.neo4j.kernel.api.labelscan.LabelScanStore;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.extension.KernelExtensionFactory;
import org.neo4j.kernel.impl.api.scan.LabelScanStoreProvider;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacadeFactory;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.spi.KernelContext;
import org.neo4j.kernel.impl.transaction.state.NeoStoresSupplier;

public class LuceneLabelScanStoreExtension
extends KernelExtensionFactory<Dependencies> {
    private final int priority;
    private final LuceneLabelScanStore.Monitor monitor;

    public LuceneLabelScanStoreExtension() {
        this(10, null);
    }

    LuceneLabelScanStoreExtension(int priority, LuceneLabelScanStore.Monitor monitor) {
        super("lucene-scan-store");
        this.priority = priority;
        this.monitor = monitor;
    }

    public LabelScanStoreProvider newInstance(KernelContext context, Dependencies dependencies) throws Throwable {
        boolean ephemeral = (Boolean)dependencies.getConfig().get(GraphDatabaseFacadeFactory.Configuration.ephemeral);
        DirectoryFactory directoryFactory = LuceneKernelExtensions.directoryFactory(ephemeral, context.fileSystem());
        LuceneLabelScanStore scanStore = new LuceneLabelScanStore(new NodeRangeDocumentLabelScanStorageStrategy(), directoryFactory, new File(new File(new File(context.storeDir(), "schema"), "label"), "lucene"), context.fileSystem(), IndexWriterFactories.tracking(), LabelScanStoreProvider.fullStoreLabelUpdateStream((NeoStoresSupplier)dependencies.getNeoStoreSupplier()), this.monitor != null ? this.monitor : LuceneLabelScanStore.loggerMonitor(dependencies.getLogService().getInternalLogProvider()));
        return new LabelScanStoreProvider((LabelScanStore)scanStore, this.priority);
    }

    public static interface Dependencies {
        public Config getConfig();

        public NeoStoresSupplier getNeoStoreSupplier();

        public LogService getLogService();
    }
}

