/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.impl.lucene;

import java.io.File;
import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.store.Directory;
import org.neo4j.index.impl.lucene.IndexIdentifier;
import org.neo4j.index.impl.lucene.IndexReference;
import org.neo4j.index.impl.lucene.IndexReferenceFactory;
import org.neo4j.index.impl.lucene.IndexTypeCache;
import org.neo4j.index.impl.lucene.LuceneDataSource;
import org.neo4j.index.impl.lucene.ReadOnlyIndexReference;

public class ReadOnlyIndexReferenceFactory
extends IndexReferenceFactory {
    public ReadOnlyIndexReferenceFactory(LuceneDataSource.LuceneFilesystemFacade filesystemFacade, File baseStorePath, IndexTypeCache typeCache) {
        super(filesystemFacade, baseStorePath, typeCache);
    }

    @Override
    IndexReference createIndexReference(IndexIdentifier identifier) throws IOException {
        IndexReader reader = IndexReader.open((Directory)this.getIndexDirectory(identifier));
        IndexSearcher indexSearcher = this.newIndexSearcher(identifier, reader);
        return new ReadOnlyIndexReference(identifier, indexSearcher);
    }

    @Override
    IndexReference refresh(IndexReference indexReference) {
        return indexReference;
    }
}

