/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.lucene;

import java.io.File;
import java.io.IOException;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.api.exceptions.index.IndexCapacityExceededException;
import org.neo4j.kernel.api.impl.index.DirectoryFactory;
import org.neo4j.kernel.api.impl.index.IndexWriterFactories;
import org.neo4j.kernel.api.impl.index.LuceneLabelScanStore;
import org.neo4j.kernel.api.impl.index.NodeRangeDocumentLabelScanStorageStrategy;
import org.neo4j.kernel.api.labelscan.LabelScanStore;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.scan.LabelScanStoreProvider;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.transaction.state.NeoStoresSupplier;
import org.neo4j.kernel.impl.transaction.state.SimpleNeoStoresSupplier;
import org.neo4j.logging.LogProvider;
import org.neo4j.udc.UsageDataKeys;

public class LuceneLabelScanStoreBuilder {
    private final File storeDir;
    private final NeoStoresSupplier neoStoresSupplier;
    private final FileSystemAbstraction fileSystem;
    private final Config config;
    private final UsageDataKeys.OperationalMode operationalMode;
    private final LogProvider logProvider;
    private LuceneLabelScanStore labelScanStore = null;

    public LuceneLabelScanStoreBuilder(File storeDir, NeoStores neoStores, FileSystemAbstraction fileSystem, Config config, UsageDataKeys.OperationalMode operationalMode, LogProvider logProvider) {
        this.storeDir = storeDir;
        this.neoStoresSupplier = new SimpleNeoStoresSupplier(neoStores);
        this.fileSystem = fileSystem;
        this.config = config;
        this.operationalMode = operationalMode;
        this.logProvider = logProvider;
    }

    public LabelScanStore build() {
        if (null == this.labelScanStore) {
            this.labelScanStore = new LuceneLabelScanStore(new NodeRangeDocumentLabelScanStorageStrategy(), DirectoryFactory.PERSISTENT, new File(new File(new File(this.storeDir, "schema"), "label"), "lucene"), this.fileSystem, IndexWriterFactories.tracking(), LabelScanStoreProvider.fullStoreLabelUpdateStream((NeoStoresSupplier)this.neoStoresSupplier), this.config, this.operationalMode, LuceneLabelScanStore.loggerMonitor(this.logProvider));
            try {
                this.labelScanStore.init();
                this.labelScanStore.start();
            }
            catch (IOException | IndexCapacityExceededException e) {
                throw new RuntimeException(e);
            }
        }
        return this.labelScanStore;
    }
}

