/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index;

import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.neo4j.io.fs.FileUtils;

public class DirectorySupport {
    public static void deleteDirectoryContents(Directory directory) throws IOException {
        for (String fileName : directory.listAll()) {
            DirectorySupport.windowsSafeDelete(directory, fileName);
        }
    }

    public static void archiveAndDeleteDirectoryContents(Directory directory, String archiveName) throws IOException {
        String[] files = directory.listAll();
        if (files.length > 0) {
            byte[] buffer = new byte[4096];
            try (ZipOutputStream zip = new ZipOutputStream(new IndexOutputStream(directory, archiveName));){
                for (String fileName : files) {
                    zip.putNextEntry(new ZipEntry(fileName));
                    try (IndexInput input = directory.openInput(fileName);){
                        int read;
                        long size = input.length();
                        for (long pos = 0L; pos < size; pos += (long)read) {
                            read = Math.min(buffer.length, (int)(size - pos));
                            input.readBytes(buffer, 0, read);
                            zip.write(buffer, 0, read);
                        }
                    }
                    zip.closeEntry();
                    DirectorySupport.windowsSafeDelete(directory, fileName);
                }
            }
        }
    }

    private static void windowsSafeDelete(final Directory directory, final String fileName) throws IOException {
        FileUtils.windowsSafeIOOperation((FileUtils.FileOperation)new FileUtils.FileOperation(){

            public void perform() throws IOException {
                directory.deleteFile(fileName);
            }
        });
    }

    private static class IndexOutputStream
    extends OutputStream {
        private final IndexOutput output;

        IndexOutputStream(Directory directory, String name) throws IOException {
            this.output = directory.createOutput(name);
        }

        @Override
        public void write(int b) throws IOException {
            this.output.writeByte((byte)(0xFF & b));
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.output.writeBytes(b, off, len);
        }

        @Override
        public void flush() throws IOException {
            this.output.flush();
        }

        @Override
        public void close() throws IOException {
            this.output.close();
        }
    }
}

