/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index;

import java.io.File;
import java.io.IOException;
import org.apache.lucene.store.Directory;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.impl.index.DeferredConstraintVerificationUniqueLuceneIndexPopulator;
import org.neo4j.kernel.api.impl.index.DirectoryFactory;
import org.neo4j.kernel.api.impl.index.IndexWriterFactories;
import org.neo4j.kernel.api.impl.index.LuceneDocumentStructure;
import org.neo4j.kernel.api.impl.index.LuceneIndexWriter;
import org.neo4j.kernel.api.impl.index.LuceneSchemaIndexProviderFactory;
import org.neo4j.kernel.api.impl.index.NonUniqueLuceneIndexAccessor;
import org.neo4j.kernel.api.impl.index.NonUniqueLuceneIndexPopulator;
import org.neo4j.kernel.api.impl.index.SearcherManagerFactories;
import org.neo4j.kernel.api.impl.index.UniqueLuceneIndexAccessor;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexConfiguration;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.InternalIndexState;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.api.index.util.FailureStorage;
import org.neo4j.kernel.api.index.util.FolderLayout;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.storemigration.SchemaIndexMigrator;
import org.neo4j.kernel.impl.storemigration.StoreMigrationParticipant;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.udc.UsageDataKeys;

public class LuceneSchemaIndexProvider
extends SchemaIndexProvider {
    private final DirectoryFactory directoryFactory;
    private final LogProvider logging;
    private final LuceneDocumentStructure documentStructure = new LuceneDocumentStructure();
    private final FailureStorage failureStorage;
    private final FolderLayout folderLayout;
    private final boolean readOnly;
    private final Log log;
    private final boolean archiveFailedIndex;

    public LuceneSchemaIndexProvider(FileSystemAbstraction fileSystem, DirectoryFactory directoryFactory, File storeDir, LogProvider logging, Config config, UsageDataKeys.OperationalMode operationalMode) {
        super(LuceneSchemaIndexProviderFactory.PROVIDER_DESCRIPTOR, 1);
        this.directoryFactory = directoryFactory;
        this.logging = logging;
        File rootDirectory = LuceneSchemaIndexProvider.getRootDirectory((File)storeDir, (String)"lucene");
        this.folderLayout = new FolderLayout(rootDirectory);
        this.failureStorage = new FailureStorage(fileSystem, this.folderLayout);
        this.readOnly = LuceneSchemaIndexProvider.isReadOnly(config, operationalMode);
        this.archiveFailedIndex = (Boolean)config.get(GraphDatabaseSettings.archive_failed_index);
        this.log = logging.getLog(((Object)((Object)this)).getClass());
    }

    public IndexPopulator getPopulator(long indexId, IndexDescriptor descriptor, IndexConfiguration config, IndexSamplingConfig samplingConfig) {
        if (this.readOnly) {
            throw new UnsupportedOperationException("Index population is not supported in read only mode.");
        }
        if (config.isUnique()) {
            return new DeferredConstraintVerificationUniqueLuceneIndexPopulator(this.documentStructure, this.logging, IndexWriterFactories.tracking(), SearcherManagerFactories.standard(), this.directoryFactory, this.folderLayout.getFolder(indexId), this.archiveFailedIndex, this.failureStorage, indexId, descriptor);
        }
        return new NonUniqueLuceneIndexPopulator(10000, this.documentStructure, this.logging, IndexWriterFactories.tracking(), this.directoryFactory, this.folderLayout.getFolder(indexId), this.archiveFailedIndex, this.failureStorage, indexId, samplingConfig);
    }

    public IndexAccessor getOnlineAccessor(long indexId, IndexConfiguration config, IndexSamplingConfig samplingConfig) throws IOException {
        if (config.isUnique()) {
            return new UniqueLuceneIndexAccessor(this.documentStructure, this.readOnly, IndexWriterFactories.reserving(), this.directoryFactory, this.folderLayout.getFolder(indexId));
        }
        return new NonUniqueLuceneIndexAccessor(this.documentStructure, this.readOnly, IndexWriterFactories.reserving(), this.directoryFactory, this.folderLayout.getFolder(indexId), samplingConfig.bufferSize());
    }

    public void shutdown() throws Throwable {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InternalIndexState getInitialState(long indexId) {
        String failure = this.failureStorage.loadIndexFailure(indexId);
        if (failure != null) {
            return InternalIndexState.FAILED;
        }
        File indexLocation = this.folderLayout.getFolder(indexId);
        try (Directory directory = this.directoryFactory.open(indexLocation);){
            boolean status = LuceneIndexWriter.isOnline(directory);
            InternalIndexState internalIndexState = status ? InternalIndexState.ONLINE : InternalIndexState.POPULATING;
            return internalIndexState;
        }
        catch (IOException e) {
            this.log.error("Failed to open index:" + indexId + ", requesting re-population.", (Throwable)e);
            return InternalIndexState.POPULATING;
        }
    }

    public StoreMigrationParticipant storeMigrationParticipant(FileSystemAbstraction fs, PageCache pageCache) {
        return new SchemaIndexMigrator(fs, pageCache, new StoreFactory());
    }

    public String getPopulationFailure(long indexId) throws IllegalStateException {
        String failure = this.failureStorage.loadIndexFailure(indexId);
        if (failure == null) {
            throw new IllegalStateException("Index " + indexId + " isn't failed");
        }
        return failure;
    }

    private static boolean isReadOnly(Config config, UsageDataKeys.OperationalMode operationalMode) {
        return (Boolean)config.get(GraphDatabaseSettings.read_only) != false && UsageDataKeys.OperationalMode.ha != operationalMode;
    }
}

