/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import org.apache.lucene.search.IndexSearcher;
import org.neo4j.collection.primitive.PrimitiveLongSet;
import org.neo4j.helpers.CancellationRequest;
import org.neo4j.kernel.api.exceptions.index.IndexCapacityExceededException;
import org.neo4j.kernel.api.impl.index.DirectoryFactory;
import org.neo4j.kernel.api.impl.index.IndexWriterFactory;
import org.neo4j.kernel.api.impl.index.LuceneDocumentStructure;
import org.neo4j.kernel.api.impl.index.LuceneIndexAccessor;
import org.neo4j.kernel.api.impl.index.LuceneUniqueIndexAccessorReader;
import org.neo4j.kernel.api.impl.index.ReservingLuceneIndexWriter;
import org.neo4j.kernel.api.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexReader;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.NodePropertyUpdate;
import org.neo4j.kernel.api.index.Reservation;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.api.index.UniquePropertyIndexUpdater;

class UniqueLuceneIndexAccessor
extends LuceneIndexAccessor {
    public UniqueLuceneIndexAccessor(LuceneDocumentStructure documentStructure, boolean readOnly, IndexWriterFactory<ReservingLuceneIndexWriter> indexWriterFactory, DirectoryFactory dirFactory, File indexFolder) throws IOException {
        super(documentStructure, readOnly, indexWriterFactory, dirFactory, indexFolder, -1);
    }

    @Override
    public IndexUpdater newUpdater(IndexUpdateMode mode) {
        return new LuceneUniquePropertyIndexUpdater(super.newUpdater(mode));
    }

    @Override
    protected IndexReader makeNewReader(IndexSearcher searcher, Closeable closeable, CancellationRequest cancellation) {
        return new LuceneUniqueIndexAccessorReader(searcher, this.documentStructure, closeable, cancellation);
    }

    private class LuceneUniquePropertyIndexUpdater
    extends UniquePropertyIndexUpdater {
        final IndexUpdater delegate;

        public LuceneUniquePropertyIndexUpdater(IndexUpdater delegate) {
            this.delegate = delegate;
        }

        protected void flushUpdates(Iterable<NodePropertyUpdate> updates) throws IOException, IndexEntryConflictException, IndexCapacityExceededException {
            for (NodePropertyUpdate update : updates) {
                this.delegate.process(update);
            }
            this.delegate.close();
        }

        public Reservation validate(Iterable<NodePropertyUpdate> updates) throws IOException, IndexCapacityExceededException {
            return this.delegate.validate(updates);
        }

        public void remove(PrimitiveLongSet nodeIds) throws IOException {
            this.delegate.remove(nodeIds);
        }
    }
}

