/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.query;

import java.io.Closeable;
import java.io.File;
import java.io.OutputStream;
import java.time.Clock;
import java.util.Map;
import java.util.function.Supplier;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.Strings;
import org.neo4j.io.file.Files;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.api.ExecutingQuery;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.extension.KernelExtensionFactory;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.query.QueryExecutionMonitor;
import org.neo4j.kernel.impl.spi.KernelContext;
import org.neo4j.kernel.impl.util.JobScheduler;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.FormattedLog;
import org.neo4j.logging.Log;
import org.neo4j.logging.RotatingFileOutputStreamSupplier;
import org.neo4j.time.Clocks;

public class QueryLoggerKernelExtension
extends KernelExtensionFactory<Dependencies> {
    public QueryLoggerKernelExtension() {
        super("query-logging");
    }

    public Lifecycle newInstance(KernelContext context, Dependencies dependencies) throws Throwable {
        final Config config = dependencies.config();
        boolean queryLogEnabled = (Boolean)config.get(GraphDatabaseSettings.log_queries);
        final File queryLogFile = (File)config.get(GraphDatabaseSettings.log_queries_filename);
        final FileSystemAbstraction fileSystem = dependencies.fileSystem();
        final JobScheduler jobScheduler = dependencies.jobScheduler();
        final Monitors monitoring = dependencies.monitoring();
        if (!queryLogEnabled) {
            return this.createEmptyAdapter();
        }
        return new LifecycleAdapter(){
            Closeable closable;

            public void init() throws Throwable {
                FormattedLog log;
                Long thresholdMillis = (Long)config.get(GraphDatabaseSettings.log_queries_threshold);
                Long rotationThreshold = (Long)config.get(GraphDatabaseSettings.log_queries_rotation_threshold);
                int maxArchives = (Integer)config.get(GraphDatabaseSettings.log_queries_max_archives);
                boolean logQueryParameters = (Boolean)config.get(GraphDatabaseSettings.log_queries_parameter_logging_enabled);
                FormattedLog.Builder logBuilder = FormattedLog.withUTCTimeZone();
                if (rotationThreshold == 0L) {
                    OutputStream logOutputStream = Files.createOrOpenAsOuputStream((FileSystemAbstraction)fileSystem, (File)queryLogFile, (boolean)true);
                    log = logBuilder.toOutputStream(logOutputStream);
                    this.closable = logOutputStream;
                } else {
                    RotatingFileOutputStreamSupplier rotatingSupplier = new RotatingFileOutputStreamSupplier(fileSystem, queryLogFile, rotationThreshold.longValue(), 0L, maxArchives, jobScheduler.executor(JobScheduler.Groups.queryLogRotation));
                    log = logBuilder.toOutputStream((Supplier)rotatingSupplier);
                    this.closable = rotatingSupplier;
                }
                QueryLogger logger = new QueryLogger(Clocks.systemClock(), (Log)log, thresholdMillis, logQueryParameters);
                monitoring.addMonitorListener((Object)logger, new String[0]);
            }

            public void shutdown() throws Throwable {
                this.closable.close();
            }
        };
    }

    private Lifecycle createEmptyAdapter() {
        return new LifecycleAdapter();
    }

    static class QueryLogger
    implements QueryExecutionMonitor {
        private final Clock clock;
        private final Log log;
        private final long thresholdMillis;
        private final boolean logQueryParameters;

        QueryLogger(Clock clock, Log log, long thresholdMillis, boolean logQueryParameters) {
            this.clock = clock;
            this.log = log;
            this.thresholdMillis = thresholdMillis;
            this.logQueryParameters = logQueryParameters;
        }

        public void startQueryExecution(ExecutingQuery query) {
        }

        public void endFailure(ExecutingQuery query, Throwable failure) {
            long time = this.clock.millis() - query.startTime();
            this.log.error(this.logEntry(time, query), failure);
        }

        public void endSuccess(ExecutingQuery query) {
            long time = this.clock.millis() - query.startTime();
            if (time >= this.thresholdMillis) {
                this.log.info(this.logEntry(time, query));
            }
        }

        private String logEntry(long time, ExecutingQuery query) {
            String sourceString = query.querySource().toString();
            String queryText = query.queryText();
            String metaData = QueryLogger.mapAsString(query.metaData());
            if (this.logQueryParameters) {
                String params = QueryLogger.mapAsString(query.queryParameters());
                return String.format("%d ms: %s - %s - %s - %s", time, sourceString, queryText, params, metaData);
            }
            return String.format("%d ms: %s - %s - %s", time, sourceString, queryText, metaData);
        }

        private static String mapAsString(Map<String, Object> params) {
            if (params == null) {
                return "{}";
            }
            StringBuilder builder = new StringBuilder("{");
            String sep = "";
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                builder.append(sep).append(entry.getKey()).append(": ").append(QueryLogger.valueToString(entry.getValue()));
                sep = ", ";
            }
            builder.append("}");
            return builder.toString();
        }

        private static String valueToString(Object value) {
            if (value instanceof Map) {
                return QueryLogger.mapAsString((Map)value);
            }
            if (value instanceof String) {
                return String.format("'%s'", String.valueOf(value));
            }
            return Strings.prettyPrint((Object)value);
        }
    }

    public static interface Dependencies {
        public FileSystemAbstraction fileSystem();

        public Config config();

        public Monitors monitoring();

        public LogService logger();

        public JobScheduler jobScheduler();
    }
}

