/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.plugins.sqltpl.impl.freemarker;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import org.nutz.dao.sql.Sql;
import org.nutz.plugins.sqltpl.NutSqlTpl;
import org.nutz.plugins.sqltpl.VarSetMap;

public class FreeMarkerSqlTpl
extends NutSqlTpl {
    private static final long serialVersionUID = 1L;
    protected static Configuration cfg;

    public FreeMarkerSqlTpl(String source) {
        super(source);
    }

    public static Sql c(Sql sql) {
        try {
            Template t = new Template("sqltpl", (Reader)new StringReader(sql.getSourceSql()), cfg);
            Map<String, Object> ctx = VarSetMap.asCtx(sql);
            StringWriter sw = new StringWriter();
            t.process(ctx, (Writer)sw);
            sql.setSourceSql(sw.toString());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (TemplateException e) {
            throw new RuntimeException(e);
        }
        return sql;
    }

    public static Configuration cfg() {
        if (cfg == null) {
            Configuration cfg = new Configuration(Configuration.VERSION_2_3_26);
            cfg.setDefaultEncoding("UTF-8");
            cfg.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
            FreeMarkerSqlTpl.cfg = cfg;
        }
        return cfg;
    }

    public static void setConfiguration(Configuration cfg) {
        FreeMarkerSqlTpl.cfg = cfg;
    }

    @Override
    protected void render() {
        FreeMarkerSqlTpl.c((Sql)this);
    }
}

