/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.boot.starter.servlet3;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventListener;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.FilterRegistration;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletRegistration;
import org.nutz.boot.AppContext;
import org.nutz.boot.NbApp;
import org.nutz.boot.starter.WebEventListenerFace;
import org.nutz.boot.starter.WebFilterFace;
import org.nutz.boot.starter.WebServletFace;
import org.nutz.ioc.loader.annotation.Inject;
import org.nutz.ioc.loader.annotation.IocBean;
import org.nutz.lang.Mirror;
import org.nutz.lang.Strings;
import org.nutz.log.Log;
import org.nutz.log.Logs;

@IocBean
public class NbServletContextListener
implements ServletContextListener {
    private static final Log log = Logs.get();
    @Inject
    protected AppContext appContext;
    protected NbApp nbApp;
    protected List<ServletContextListener> listeners = new LinkedList<ServletContextListener>();
    protected ServletContext sc;

    public void contextInitialized(ServletContextEvent sce) {
        ServletContext _sc = sce.getServletContext();
        if (_sc.getClass().getSimpleName().equals("NoPluggabilityServletContext")) {
            _sc = (ServletContext)Mirror.me((Object)_sc).getValue((Object)_sc, "sc");
        }
        this.sc = _sc;
        if (this.appContext == null && this.sc.getInitParameter("nutzboot.mainClass") != null) {
            String mainClassName = this.sc.getInitParameter("nutzboot.mainClass");
            try {
                log.info((Object)("Running at war mode!!! mainClass=" + mainClassName));
                Class<?> klass = Class.forName(mainClassName);
                Method method = null;
                try {
                    method = klass.getMethod("warMain", ServletContext.class);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
                if (method != null) {
                    try {
                        this.nbApp = (NbApp)method.invoke(null, this.sc);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                } else {
                    this.nbApp = new NbApp(klass);
                    String mainPackage = this.sc.getInitParameter("nutzboot.mainPackage");
                    if (Strings.isNotBlank((CharSequence)mainPackage)) {
                        this.nbApp.setMainPackage(mainPackage);
                    }
                }
                this.appContext = this.nbApp.getAppContext();
                this.nbApp.execute();
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        this.appContext.getBeans(WebServletFace.class).forEach(face -> {
            face.setServletContext(this.sc);
            Servlet servlet = face.getServlet();
            if (servlet == null) {
                return;
            }
            ServletRegistration.Dynamic dyna = this.sc.addServlet(face.getName(), servlet);
            if (dyna == null) {
                log.infof("addServlet return null?! maybe define in web.xml as same name=%s", new Object[]{face.getName()});
                return;
            }
            for (String pathSpec : face.getPathSpecs()) {
                log.debugf("add Servlet name=%s pathSpec=%s", new Object[]{face.getName(), pathSpec});
                dyna.addMapping(new String[]{pathSpec});
            }
            dyna.setInitParameters(face.getInitParameters());
        });
        this.appContext.getBeans(WebEventListenerFace.class).forEach(face -> {
            EventListener en = face.getEventListener();
            if (en != null) {
                if (en instanceof ServletContextListener) {
                    this.listeners.add((ServletContextListener)en);
                    ((ServletContextListener)en).contextInitialized(new ServletContextEvent(this.sc));
                } else {
                    this.sc.addListener(face.getEventListener());
                }
            }
        });
        List filters = this.appContext.getBeans(WebFilterFace.class);
        Collections.sort(filters, Comparator.comparing(WebFilterFace::getOrder));
        filters.forEach(face -> {
            face.setServletContext(this.sc);
            if (face.getFilter() == null) {
                return;
            }
            FilterRegistration.Dynamic dyna = this.sc.addFilter(face.getName(), face.getFilter());
            if (dyna == null) {
                log.infof("addFilter return null?! maybe define in web.xml as same name=%s", new Object[]{face.getName()});
                return;
            }
            log.debugf("add filter name=%s pathSpec=%s", new Object[]{face.getName(), face.getPathSpec()});
            dyna.setInitParameters(face.getInitParameters());
            dyna.addMappingForUrlPatterns(face.getDispatches(), true, new String[]{face.getPathSpec()});
        });
    }

    public void contextDestroyed(ServletContextEvent sce) {
        for (ServletContextListener listener : this.listeners) {
            try {
                listener.contextDestroyed(new ServletContextEvent(this.sc));
            }
            catch (Throwable e) {
                log.info((Object)"something happen when contextDestroyed", e);
            }
        }
        if (this.nbApp != null) {
            this.nbApp._shutdown();
        }
    }
}

