/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugin.clover.internal;

import clover.org.apache.commons.lang3.StringUtils;
import com.atlassian.clover.util.IOStreamUtils;
import com.atlassian.maven.plugin.clover.DistributedCoverage;
import com.atlassian.maven.plugin.clover.MethodWithMetricsContext;
import com.atlassian.maven.plugin.clover.TestSources;
import com.atlassian.maven.plugin.clover.internal.AbstractCloverMojo;
import com.atlassian.maven.plugin.clover.internal.CompilerConfiguration;
import com.atlassian.maven.plugin.clover.internal.lifecycle.BuildLifecycleAnalyzer;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.lifecycle.LifecycleExecutor;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

public abstract class AbstractCloverInstrumentMojo
extends AbstractCloverMojo
implements CompilerConfiguration {
    @Parameter(property="maven.clover.cloveredArtifactExpiryInMillis", defaultValue="2000")
    protected long cloveredArtifactExpiryInMillis;
    @Parameter(property="maven.clover.copyExcludedFiles", defaultValue="true")
    protected boolean copyExcludedFiles = true;
    @Parameter
    protected DistributedCoverage distributedCoverage;
    @Parameter(property="maven.clover.encoding")
    protected String encoding;
    @Parameter
    protected Set<String> excludes = new HashSet<String>();
    @Parameter(property="maven.clover.excludesList")
    protected String excludesList = null;
    @Parameter(property="maven.clover.excludesFile")
    protected String excludesFile = null;
    @Parameter(property="maven.clover.flushPolicy", defaultValue="threaded")
    protected String flushPolicy;
    @Parameter(property="maven.clover.groverJar")
    protected File groverJar;
    @Parameter
    protected Set<String> includes = new HashSet<String>(Arrays.asList("**/*.java", "**/*.groovy"));
    @Parameter(property="maven.clover.includesList")
    protected String includesList = null;
    @Parameter(property="maven.clover.includesFile")
    protected String includesFile = null;
    @Parameter(property="maven.clover.includesAllSourceRoots", defaultValue="false")
    protected boolean includesAllSourceRoots;
    @Parameter(property="maven.clover.includesTestSourceRoots", defaultValue="true")
    protected boolean includesTestSourceRoots;
    @Parameter(property="maven.clover.instrumentation", defaultValue="statement")
    protected String instrumentation;
    @Parameter(property="maven.clover.instrumentLambda", defaultValue="none")
    private String instrumentLambda;
    @Parameter(property="maven.clover.jdk")
    protected String jdk;
    @Parameter
    protected Map<String, String> methodContexts = new HashMap<String, String>();
    @Parameter
    protected Set<MethodWithMetricsContext> methodWithMetricsContexts = new HashSet<MethodWithMetricsContext>();
    @Parameter(property="maven.clover.repositoryPollutionProtection", defaultValue="false")
    protected boolean repositoryPollutionProtection;
    @Parameter(property="maven.clover.scope")
    protected String scope;
    @Parameter(property="maven.clover.setTestFailureIgnore", defaultValue="false")
    protected boolean setTestFailureIgnore;
    @Parameter(property="maven.clover.skipGroverJar", defaultValue="false")
    protected boolean skipGroverJar = false;
    @Parameter
    protected Map<String, String> statementContexts = new HashMap<String, String>();
    @Parameter(property="maven.clover.staleMillis", defaultValue="0")
    protected int staleMillis;
    @Parameter
    protected TestSources testSources;
    @Parameter(property="maven.clover.useCloverClassifier", defaultValue="true")
    protected boolean useCloverClassifier;
    @Parameter(property="maven.clover.useFullyQualifiedJavaLang", defaultValue="true")
    protected boolean useFullyQualifiedJavaLang;
    @Component
    private LifecycleExecutor lifecycleExecutor;
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession mavenSession;
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject mavenProject;
    private static final String PROTECTION_ENABLED_MSG = "Clover's repository pollution protection is enabled. ";
    private static final String DISABLING_PROTECTION_MSG = "You can also disable repository pollution protection (-Dmaven.clover.repositoryPollutionProtection=false) if this is intentional.";

    @Override
    public void execute() throws MojoExecutionException {
        super.execute();
        if (this.repositoryPollutionProtection) {
            BuildLifecycleAnalyzer lifecycleAnalyzer = new BuildLifecycleAnalyzer(this.getLog(), this.lifecycleExecutor, this.mavenProject, this.mavenSession);
            this.failIfDeployPhaseIsPresent(lifecycleAnalyzer);
            this.failIfInstallPhaseIsPresent(lifecycleAnalyzer);
            this.failIfCustomClassifierIsPresent();
        }
    }

    protected abstract boolean shouldRedirectArtifacts();

    protected abstract boolean shouldRedirectOutputDirectories();

    @Override
    public boolean isCopyExcludedFiles() {
        return this.copyExcludedFiles;
    }

    @Override
    public String getEncoding() {
        return this.encoding;
    }

    @Override
    public DistributedCoverage getDistributedCoverage() {
        return this.distributedCoverage;
    }

    @Override
    public Set<String> getExcludes() {
        if (this.excludesList == null && this.excludesFile == null) {
            return this.excludes;
        }
        if (this.excludesFile != null) {
            try {
                return this.readPathPatternsFromFile(this.excludesFile);
            }
            catch (IOException e) {
                this.getLog().error((CharSequence)("Could not read excludesFile: " + this.excludesFile), (Throwable)e);
                return Collections.emptySet();
            }
        }
        this.excludes.addAll(Arrays.asList(this.excludesList.split(",")));
        return this.excludes;
    }

    @Override
    public String getFlushPolicy() {
        return this.flushPolicy;
    }

    @Override
    public Set<String> getIncludes() {
        if (this.includesList == null && this.includesFile == null) {
            return this.includes;
        }
        if (this.includesFile != null) {
            try {
                return this.readPathPatternsFromFile(this.includesFile);
            }
            catch (IOException e) {
                this.getLog().error((CharSequence)("Could not read includesFile: " + this.includesFile), (Throwable)e);
                return Collections.emptySet();
            }
        }
        return new HashSet<String>(Arrays.asList(this.includesList.split(",")));
    }

    @Override
    public String getInstrumentation() {
        return this.instrumentation;
    }

    @Override
    public String getInstrumentLambda() {
        return this.instrumentLambda;
    }

    @Override
    public String getJdk() {
        return this.jdk;
    }

    @Override
    public Map<String, String> getMethodContexts() {
        return this.methodContexts;
    }

    @Override
    public Set<MethodWithMetricsContext> getMethodWithMetricsContexts() {
        return this.methodWithMetricsContexts;
    }

    @Override
    public Map<String, String> getStatementContexts() {
        return this.statementContexts;
    }

    @Override
    public int getStaleMillis() {
        return this.staleMillis;
    }

    @Override
    public boolean isIncludesAllSourceRoots() {
        return this.includesAllSourceRoots;
    }

    @Override
    public boolean isUseFullyQualifiedJavaLang() {
        return this.useFullyQualifiedJavaLang;
    }

    @Override
    public TestSources getTestSources() {
        return this.testSources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> readPathPatternsFromFile(String file) throws IOException {
        HashSet<String> files = new HashSet<String>();
        BufferedReader br = null;
        try {
            String line;
            br = new BufferedReader(new FileReader(file));
            while ((line = br.readLine()) != null) {
                files.add(line);
            }
        }
        catch (Throwable throwable) {
            IOStreamUtils.close(br);
            throw throwable;
        }
        IOStreamUtils.close((Closeable)br);
        return files;
    }

    protected void failIfInstallPhaseIsPresent(BuildLifecycleAnalyzer lifecycleAnalyzer) throws MojoExecutionException {
        if (!(!lifecycleAnalyzer.isInstallPresent() || this.useCloverClassifier && this.shouldRedirectArtifacts())) {
            throw new MojoExecutionException("Clover's repository pollution protection is enabled. Your build runs 'install' phase which can put instrumented JARs into ~/.m2 local cache. In order to fix this: \n - run a build till the 'verify' phase (the latest)\n - check if some build plug-in does not fork a parallel build cycle which runs till the 'install' phase\nYou can also disable repository pollution protection (-Dmaven.clover.repositoryPollutionProtection=false) if this is intentional.");
        }
    }

    protected void failIfDeployPhaseIsPresent(BuildLifecycleAnalyzer lifecycleAnalyzer) throws MojoExecutionException {
        if (!(!lifecycleAnalyzer.isDeployPresent() || this.useCloverClassifier && this.shouldRedirectArtifacts())) {
            throw new MojoExecutionException("Clover's repository pollution protection is enabled. Your build runs 'deploy' phase which can upload instrumented JARs into your repository. In order to fix this: \n - run a build till the 'verify' phase (the latest)\n - check if some build plug-in does not fork a parallel build cycle which runs till the 'deploy' phase\nYou can also disable repository pollution protection (-Dmaven.clover.repositoryPollutionProtection=false) if this is intentional.");
        }
    }

    protected void failIfCustomClassifierIsPresent() throws MojoExecutionException {
        boolean customClassifierUsed;
        String classifier = this.getProject().getArtifact().getClassifier();
        boolean bl = customClassifierUsed = StringUtils.isNotEmpty((CharSequence)classifier) && !"javadoc".equals(classifier) && !"sources".equals(classifier);
        if (customClassifierUsed && this.useCloverClassifier && this.shouldRedirectArtifacts()) {
            throw new MojoExecutionException("Clover's repository pollution protection is enabled. Your build produces an artifact (" + this.getProject().getArtifact() + ") with a custom classifier. As Maven does not support multiple classifiers for an artifact, appending second 'clover' classifier may not be handled correctly. You can: \n - remove a custom classifier or\n - configure Clover to not append the '-clover' classifier \nto fix it. You can also disable pollution protection (-Dmaven.clover.repositoryPollutionProtection=false) if you know that it doesn't affect your build. ");
        }
    }
}

