/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.gradle.IsBuildGradle;
import org.openrewrite.groovy.GroovyVisitor;
import org.openrewrite.groovy.tree.G;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.marker.Markers;

public class DependencyUseStringNotation
extends Recipe {
    public String getDisplayName() {
        return "Use `String` notation for Gradle dependency declarations";
    }

    public String getDescription() {
        return "In Gradle, dependencies can be expressed as a `String` like `\"groupId:artifactId:version\"`, or equivalently as a `Map` like `group: 'groupId', name: 'artifactId', version: 'version'`. This recipe replaces dependencies represented as `Maps` with an equivalent dependency represented as a `String`.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final MethodMatcher dependencyDsl = new MethodMatcher("DependencyHandlerSpec *(..)");
        return Preconditions.check(new IsBuildGradle(), (TreeVisitor)new GroovyVisitor<ExecutionContext>(){

            public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext context) {
                J.MethodInvocation m = (J.MethodInvocation)super.visitMethodInvocation(method, (Object)context);
                if (!dependencyDsl.matches(m)) {
                    return m;
                }
                if (m.getArguments().isEmpty()) {
                    return m;
                }
                HashMap<String, Expression> mapNotation = new HashMap<String, Expression>();
                if (m.getArguments().get(0) instanceof G.MapLiteral) {
                    G.MapLiteral arg = (G.MapLiteral)m.getArguments().get(0);
                    for (G.MapEntry entry : arg.getElements()) {
                        J.Literal key;
                        if (!(entry.getKey() instanceof J.Literal) || (key = (J.Literal)entry.getKey()).getType() != JavaType.Primitive.String) continue;
                        mapNotation.put((String)key.getValue(), entry.getValue());
                    }
                    J.Literal stringNotation = this.toLiteral(arg.getPrefix(), arg.getMarkers(), mapNotation);
                    if (stringNotation == null) {
                        return m;
                    }
                    Expression lastArg = (Expression)m.getArguments().get(m.getArguments().size() - 1);
                    m = lastArg instanceof J.Lambda ? m.withArguments(Arrays.asList(stringNotation, lastArg)) : m.withArguments(Collections.singletonList(stringNotation));
                } else if (m.getArguments().get(0) instanceof G.MapEntry) {
                    G.MapEntry firstEntry = (G.MapEntry)m.getArguments().get(0);
                    Space prefix = firstEntry.getPrefix();
                    Markers markers = firstEntry.getMarkers();
                    for (Expression e : m.getArguments()) {
                        J.Literal key;
                        G.MapEntry entry;
                        if (!(e instanceof G.MapEntry) || !((entry = (G.MapEntry)e).getKey() instanceof J.Literal) || (key = (J.Literal)entry.getKey()).getType() != JavaType.Primitive.String) continue;
                        mapNotation.put((String)key.getValue(), entry.getValue());
                    }
                    J.Literal stringNotation = this.toLiteral(prefix, markers, mapNotation);
                    if (stringNotation == null) {
                        return m;
                    }
                    Expression lastArg = (Expression)m.getArguments().get(m.getArguments().size() - 1);
                    m = lastArg instanceof J.Lambda ? m.withArguments(Arrays.asList(stringNotation, lastArg)) : m.withArguments(Collections.singletonList(stringNotation));
                }
                return m;
            }

            @Nullable
            private J.Literal toLiteral(Space prefix, Markers markers, Map<String, Expression> mapNotation) {
                if (mapNotation.containsKey("group") && mapNotation.containsKey("name")) {
                    String version;
                    String name;
                    String stringNotation = "";
                    String group = this.coerceToStringNotation(mapNotation.get("group"));
                    if (group != null) {
                        stringNotation = stringNotation + group;
                    }
                    if ((name = this.coerceToStringNotation(mapNotation.get("name"))) != null) {
                        stringNotation = stringNotation + ":" + name;
                    }
                    if ((version = this.coerceToStringNotation(mapNotation.get("version"))) != null) {
                        stringNotation = stringNotation + ":" + version;
                    }
                    return new J.Literal(Tree.randomId(), prefix, markers, (Object)stringNotation, "\"" + stringNotation + "\"", Collections.emptyList(), JavaType.Primitive.String);
                }
                return null;
            }

            @Nullable
            private String coerceToStringNotation(Expression expression) {
                if (expression instanceof J.Literal) {
                    return (String)((J.Literal)expression).getValue();
                }
                if (expression instanceof J.Identifier) {
                    return "$" + ((J.Identifier)expression).getSimpleName();
                }
                return null;
            }
        });
    }
}

