/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle.util;

import java.io.IOException;
import java.net.URI;
import org.openrewrite.Checksum;
import org.openrewrite.gradle.util.GradleWrapper;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.ipc.http.HttpSender;

public final class DistributionInfos {
    private final String downloadUrl;
    @Nullable
    private final Checksum checksum;
    @Nullable
    private final Checksum wrapperJarChecksum;

    static DistributionInfos fetch(HttpSender httpSender, GradleWrapper.DistributionType distributionType, GradleWrapper.GradleVersion gradleVersion) throws IOException {
        String downloadUrl = DistributionInfos.toDistTypeUrl(distributionType, gradleVersion.getDownloadUrl());
        Checksum checksum = DistributionInfos.fetchChecksum(httpSender, DistributionInfos.toDistTypeUrl(distributionType, gradleVersion.getChecksumUrl()));
        Checksum jarChecksum = DistributionInfos.fetchChecksum(httpSender, gradleVersion.getWrapperChecksumUrl());
        return new DistributionInfos(downloadUrl, checksum, jarChecksum);
    }

    private static String toDistTypeUrl(GradleWrapper.DistributionType distributionType, String binUrl) {
        if (distributionType == GradleWrapper.DistributionType.All) {
            return binUrl.replace("-bin.zip", "-all.zip");
        }
        return binUrl;
    }

    private static Checksum fetchChecksum(HttpSender httpSender, String checksumUrl) {
        return Checksum.fromUri((HttpSender)httpSender, (URI)URI.create(checksumUrl));
    }

    public DistributionInfos(String downloadUrl, @Nullable Checksum checksum, @Nullable Checksum wrapperJarChecksum) {
        this.downloadUrl = downloadUrl;
        this.checksum = checksum;
        this.wrapperJarChecksum = wrapperJarChecksum;
    }

    public String getDownloadUrl() {
        return this.downloadUrl;
    }

    @Nullable
    public Checksum getChecksum() {
        return this.checksum;
    }

    @Nullable
    public Checksum getWrapperJarChecksum() {
        return this.wrapperJarChecksum;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DistributionInfos)) {
            return false;
        }
        DistributionInfos other = (DistributionInfos)o;
        String this$downloadUrl = this.getDownloadUrl();
        String other$downloadUrl = other.getDownloadUrl();
        if (this$downloadUrl == null ? other$downloadUrl != null : !this$downloadUrl.equals(other$downloadUrl)) {
            return false;
        }
        Checksum this$checksum = this.getChecksum();
        Checksum other$checksum = other.getChecksum();
        if (this$checksum == null ? other$checksum != null : !this$checksum.equals(other$checksum)) {
            return false;
        }
        Checksum this$wrapperJarChecksum = this.getWrapperJarChecksum();
        Checksum other$wrapperJarChecksum = other.getWrapperJarChecksum();
        return !(this$wrapperJarChecksum == null ? other$wrapperJarChecksum != null : !this$wrapperJarChecksum.equals(other$wrapperJarChecksum));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $downloadUrl = this.getDownloadUrl();
        result = result * 59 + ($downloadUrl == null ? 43 : $downloadUrl.hashCode());
        Checksum $checksum = this.getChecksum();
        result = result * 59 + ($checksum == null ? 43 : $checksum.hashCode());
        Checksum $wrapperJarChecksum = this.getWrapperJarChecksum();
        result = result * 59 + ($wrapperJarChecksum == null ? 43 : $wrapperJarChecksum.hashCode());
        return result;
    }

    @NonNull
    public String toString() {
        return "DistributionInfos(downloadUrl=" + this.getDownloadUrl() + ", checksum=" + this.getChecksum() + ", wrapperJarChecksum=" + this.getWrapperJarChecksum() + ")";
    }
}

