/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle.plugins;

import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.Tree;
import org.openrewrite.gradle.DependencyVersionSelector;
import org.openrewrite.gradle.GradleParser;
import org.openrewrite.gradle.marker.GradleProject;
import org.openrewrite.gradle.marker.GradleSettings;
import org.openrewrite.gradle.search.FindPlugins;
import org.openrewrite.groovy.GroovyIsoVisitor;
import org.openrewrite.groovy.tree.G;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.FindMethods;
import org.openrewrite.java.tree.Comment;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TextComment;
import org.openrewrite.maven.MavenDownloadingException;
import org.openrewrite.maven.tree.GroupArtifact;
import org.openrewrite.tree.ParseError;

public final class AddPluginVisitor
extends GroovyIsoVisitor<ExecutionContext> {
    private final String pluginId;
    @Nullable
    private final String newVersion;
    @Nullable
    private final String versionPattern;
    @Nullable
    private final Boolean apply;

    @Nullable
    private static Comment getLicenseHeader(G.CompilationUnit cu) {
        Comment firstComment;
        if (!cu.getStatements().isEmpty()) {
            Comment firstComment2;
            Statement firstStatement = (Statement)cu.getStatements().get(0);
            if (!firstStatement.getComments().isEmpty() && AddPluginVisitor.isLicenseHeader(firstComment2 = (Comment)firstStatement.getComments().get(0))) {
                return firstComment2;
            }
        } else if (cu.getEof() != null && !cu.getEof().getComments().isEmpty() && AddPluginVisitor.isLicenseHeader(firstComment = (Comment)cu.getEof().getComments().get(0))) {
            return firstComment.withSuffix("\n\n");
        }
        return null;
    }

    private static boolean isLicenseHeader(Comment comment) {
        return comment instanceof TextComment && comment.isMultiline() && ((TextComment)comment).getText().contains("License");
    }

    private static G.CompilationUnit removeLicenseHeader(G.CompilationUnit cu) {
        if (!cu.getStatements().isEmpty()) {
            return cu.withStatements(ListUtils.mapFirst((List)cu.getStatements(), s -> (Statement)s.withComments(s.getComments().subList(1, s.getComments().size()))));
        }
        List eofComments = cu.getEof().getComments();
        return cu.withEof(cu.getEof().withComments(eofComments.subList(1, eofComments.size())));
    }

    public G.CompilationUnit visitCompilationUnit(G.CompilationUnit cu, ExecutionContext ctx) {
        if (FindPlugins.find((J)cu, this.pluginId).isEmpty()) {
            String version;
            if (this.newVersion == null) {
                version = null;
            } else {
                Optional maybeGp = cu.getMarkers().findFirst(GradleProject.class);
                Optional maybeGs = cu.getMarkers().findFirst(GradleSettings.class);
                if (!maybeGp.isPresent() && !maybeGs.isPresent()) {
                    return cu;
                }
                try {
                    version = new DependencyVersionSelector(null, maybeGp.orElse(null), maybeGs.orElse(null)).select(new GroupArtifact(this.pluginId, this.pluginId + ".gradle.plugin"), "classpath", this.newVersion, this.versionPattern, ctx);
                }
                catch (MavenDownloadingException e) {
                    return (G.CompilationUnit)e.warn((Tree)cu);
                }
            }
            final AtomicInteger singleQuote = new AtomicInteger();
            final AtomicInteger doubleQuote = new AtomicInteger();
            new GroovyIsoVisitor<Integer>(){
                final MethodMatcher pluginIdMatcher = new MethodMatcher("PluginSpec id(..)");

                public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, Integer integer) {
                    J.MethodInvocation m = super.visitMethodInvocation(method, (Object)integer);
                    if (this.pluginIdMatcher.matches((MethodCall)m) && m.getArguments().get(0) instanceof J.Literal) {
                        J.Literal l = (J.Literal)m.getArguments().get(0);
                        assert (l.getValueSource() != null);
                        if (l.getValueSource().startsWith("'")) {
                            singleQuote.incrementAndGet();
                        } else {
                            doubleQuote.incrementAndGet();
                        }
                    }
                    return m;
                }
            }.visitCompilationUnit(cu, (Object)0);
            String delimiter = singleQuote.get() < doubleQuote.get() ? "\"" : "'";
            String source = "plugins {\n    id " + delimiter + this.pluginId + delimiter + (version != null ? " version " + delimiter + version + delimiter : "") + (version != null && Boolean.FALSE.equals(this.apply) ? " apply " + this.apply : "") + "\n}";
            Statement statement = GradleParser.builder().build().parseInputs(Collections.singletonList(Parser.Input.fromString((String)source)), null, ctx).findFirst().map(parsed -> {
                if (parsed instanceof ParseError) {
                    throw ((ParseError)parsed).toException();
                }
                return (G.CompilationUnit)parsed;
            }).map(parsed -> (Statement)parsed.getStatements().get(0)).orElseThrow(() -> new IllegalArgumentException("Could not parse as Gradle"));
            if (FindMethods.find((J)cu, (String)"RewriteGradleProject plugins(..)").isEmpty() && FindMethods.find((J)cu, (String)"RewriteSettings plugins(..)").isEmpty()) {
                if (cu.getSourcePath().endsWith(Paths.get("settings.gradle", new String[0])) && !cu.getStatements().isEmpty() && cu.getStatements().get(0) instanceof J.MethodInvocation && ((J.MethodInvocation)cu.getStatements().get(0)).getSimpleName().equals("pluginManagement")) {
                    return cu.withStatements(ListUtils.insert((List)cu.getStatements(), (Object)((Statement)this.autoFormat((J)((Statement)statement.withPrefix(Space.format((String)"\n\n"))), ctx, this.getCursor())), (int)1));
                }
                int insertAtIdx = 0;
                for (int i = 0; i < cu.getStatements().size(); ++i) {
                    Statement existingStatement = (Statement)cu.getStatements().get(i);
                    if (!(existingStatement instanceof J.MethodInvocation) || !((J.MethodInvocation)existingStatement).getSimpleName().equals("buildscript")) continue;
                    insertAtIdx = i + 1;
                    break;
                }
                if (insertAtIdx == 0) {
                    Comment licenseHeader = AddPluginVisitor.getLicenseHeader(cu);
                    if (licenseHeader != null) {
                        cu = AddPluginVisitor.removeLicenseHeader(cu);
                        statement = (Statement)statement.withComments(Collections.singletonList(licenseHeader));
                    }
                    Space leadingSpace = Space.firstPrefix((List)cu.getStatements());
                    return cu.withStatements(ListUtils.insert((List)Space.formatFirstPrefix((List)cu.getStatements(), (Space)leadingSpace.withWhitespace("\n\n" + leadingSpace.getWhitespace())), (Object)((Statement)this.autoFormat((J)statement, ctx, this.getCursor())), (int)insertAtIdx));
                }
                return cu.withStatements(ListUtils.insert((List)cu.getStatements(), (Object)((Statement)this.autoFormat((J)((Statement)statement.withPrefix(Space.format((String)"\n\n"))), ctx, this.getCursor())), (int)insertAtIdx));
            }
            MethodMatcher buildPluginsMatcher = new MethodMatcher("RewriteGradleProject plugins(groovy.lang.Closure)");
            MethodMatcher settingsPluginsMatcher = new MethodMatcher("RewriteSettings plugins(groovy.lang.Closure)");
            J.MethodInvocation pluginDef = (J.MethodInvocation)((J.Return)((J.Block)((J.Lambda)((J.MethodInvocation)this.autoFormat((J)statement, ctx, this.getCursor())).getArguments().get(0)).getBody()).getStatements().get(0)).getExpression();
            return cu.withStatements(ListUtils.map((List)cu.getStatements(), stat -> {
                J.MethodInvocation m;
                if (stat instanceof J.MethodInvocation && (buildPluginsMatcher.matches((MethodCall)(m = (J.MethodInvocation)stat)) || settingsPluginsMatcher.matches((MethodCall)m))) {
                    m = m.withArguments(ListUtils.map((List)m.getArguments(), a -> {
                        if (a instanceof J.Lambda) {
                            J.Lambda l = (J.Lambda)a;
                            J.Block b = (J.Block)l.getBody();
                            List pluginStatements = b.getStatements();
                            if (!pluginStatements.isEmpty() && pluginStatements.get(pluginStatements.size() - 1) instanceof J.Return) {
                                Statement last = (Statement)pluginStatements.remove(pluginStatements.size() - 1);
                                Expression lastExpr = Objects.requireNonNull(((J.Return)last).getExpression());
                                pluginStatements.add((Statement)lastExpr.withPrefix(last.getPrefix()));
                            }
                            pluginStatements.add(pluginDef);
                            return l.withBody(this.autoFormat((J)b.withStatements(pluginStatements), ctx, this.getCursor()));
                        }
                        return a;
                    }));
                    return m;
                }
                return stat;
            }));
        }
        return super.visitCompilationUnit(cu, (Object)ctx);
    }

    public AddPluginVisitor(String pluginId, @Nullable String newVersion, @Nullable String versionPattern, @Nullable Boolean apply) {
        this.pluginId = pluginId;
        this.newVersion = newVersion;
        this.versionPattern = versionPattern;
        this.apply = apply;
    }

    public String getPluginId() {
        return this.pluginId;
    }

    @Nullable
    public String getNewVersion() {
        return this.newVersion;
    }

    @Nullable
    public String getVersionPattern() {
        return this.versionPattern;
    }

    @Nullable
    public Boolean getApply() {
        return this.apply;
    }

    @NonNull
    public String toString() {
        return "AddPluginVisitor(pluginId=" + this.getPluginId() + ", newVersion=" + this.getNewVersion() + ", versionPattern=" + this.getVersionPattern() + ", apply=" + this.getApply() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddPluginVisitor)) {
            return false;
        }
        AddPluginVisitor other = (AddPluginVisitor)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$apply = this.getApply();
        Boolean other$apply = other.getApply();
        if (this$apply == null ? other$apply != null : !((Object)this$apply).equals(other$apply)) {
            return false;
        }
        String this$pluginId = this.getPluginId();
        String other$pluginId = other.getPluginId();
        if (this$pluginId == null ? other$pluginId != null : !this$pluginId.equals(other$pluginId)) {
            return false;
        }
        String this$newVersion = this.getNewVersion();
        String other$newVersion = other.getNewVersion();
        if (this$newVersion == null ? other$newVersion != null : !this$newVersion.equals(other$newVersion)) {
            return false;
        }
        String this$versionPattern = this.getVersionPattern();
        String other$versionPattern = other.getVersionPattern();
        return !(this$versionPattern == null ? other$versionPattern != null : !this$versionPattern.equals(other$versionPattern));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof AddPluginVisitor;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $apply = this.getApply();
        result = result * 59 + ($apply == null ? 43 : ((Object)$apply).hashCode());
        String $pluginId = this.getPluginId();
        result = result * 59 + ($pluginId == null ? 43 : $pluginId.hashCode());
        String $newVersion = this.getNewVersion();
        result = result * 59 + ($newVersion == null ? 43 : $newVersion.hashCode());
        String $versionPattern = this.getVersionPattern();
        result = result * 59 + ($versionPattern == null ? 43 : $versionPattern.hashCode());
        return result;
    }
}

