/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle.plugins;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Parser;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.gradle.GradleParser;
import org.openrewrite.gradle.IsSettingsGradle;
import org.openrewrite.gradle.search.FindRepository;
import org.openrewrite.groovy.GroovyIsoVisitor;
import org.openrewrite.groovy.tree.G;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;

public final class AddSettingsPluginRepository
extends Recipe {
    @Option(displayName="Type", description="The type of the artifact repository", example="maven")
    private final String type;
    @Option(displayName="URL", description="The url of the artifact repository", required=false, example="https://repo.spring.io")
    private final String url;

    public String getDisplayName() {
        return "Add a Gradle settings repository";
    }

    public String getDescription() {
        return "Add a Gradle settings repository to `settings.gradle(.kts)`.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check(new IsSettingsGradle(), (TreeVisitor)new GroovyIsoVisitor<ExecutionContext>(){

            public G.CompilationUnit visitCompilationUnit(G.CompilationUnit cu, ExecutionContext ctx) {
                if (cu == new FindRepository(AddSettingsPluginRepository.this.type, AddSettingsPluginRepository.this.url, FindRepository.Purpose.Plugin).getVisitor().visit((Tree)cu, (Object)ctx)) {
                    G.CompilationUnit g = super.visitCompilationUnit(cu, (Object)ctx);
                    J.MethodInvocation pluginManagement = this.generatePluginManagementBlock(ctx);
                    ArrayList<Object> statements = new ArrayList<Object>(g.getStatements());
                    if (statements.isEmpty()) {
                        statements.add(pluginManagement);
                    } else {
                        Statement statement = (Statement)statements.get(0);
                        if (statement instanceof J.MethodInvocation && ((J.MethodInvocation)statement).getSimpleName().equals("pluginManagement")) {
                            J.MethodInvocation m = (J.MethodInvocation)statement;
                            m = m.withArguments(ListUtils.mapFirst((List)m.getArguments(), arg -> {
                                if (arg instanceof J.Lambda && ((J.Lambda)arg).getBody() instanceof J.Block) {
                                    J.Lambda lambda = (J.Lambda)arg;
                                    J.Block block = (J.Block)lambda.getBody();
                                    return lambda.withBody((J)block.withStatements(ListUtils.map((List)block.getStatements(), statement2 -> {
                                        if (statement2 instanceof J.MethodInvocation && ((J.MethodInvocation)statement2).getSimpleName().equals("repositories") || statement2 instanceof J.Return && ((J.Return)statement2).getExpression() instanceof J.MethodInvocation && ((J.MethodInvocation)((J.Return)statement2).getExpression()).getSimpleName().equals("repositories")) {
                                            J.MethodInvocation m2 = (J.MethodInvocation)(statement2 instanceof J.Return ? ((J.Return)statement2).getExpression() : statement2);
                                            return m2.withArguments(ListUtils.mapFirst((List)m2.getArguments(), arg2 -> {
                                                if (arg2 instanceof J.Lambda && ((J.Lambda)arg2).getBody() instanceof J.Block) {
                                                    J.Lambda lambda2 = (J.Lambda)arg2;
                                                    J.Block block2 = (J.Block)lambda2.getBody();
                                                    return lambda2.withBody((J)block2.withStatements(ListUtils.concat((List)block2.getStatements(), (Object)this.extractRepository(pluginManagement))));
                                                }
                                                return arg2;
                                            }));
                                        }
                                        return statement2;
                                    })));
                                }
                                return arg;
                            }));
                            statements.set(0, m);
                        } else {
                            statements.add(0, pluginManagement);
                            statements.set(1, (Statement)((Statement)statements.get(1)).withPrefix(Space.format((String)"\n\n")));
                        }
                    }
                    return (G.CompilationUnit)this.autoFormat((J)g.withStatements(statements), ctx);
                }
                return cu;
            }

            private J.MethodInvocation generatePluginManagementBlock(ExecutionContext ctx) {
                String code = AddSettingsPluginRepository.this.url == null ? "pluginManagement {    repositories {        " + AddSettingsPluginRepository.this.type + "()    }}" : "pluginManagement {    repositories {        " + AddSettingsPluginRepository.this.type + " {            url = \"" + AddSettingsPluginRepository.this.url + "\"        }    }}";
                return (J.MethodInvocation)((G.CompilationUnit)GradleParser.builder().build().parseInputs(Collections.singletonList(Parser.Input.fromString((Path)Paths.get("settings.gradle", new String[0]), (String)code)), null, ctx).map(G.CompilationUnit.class::cast).collect(Collectors.toList()).get(0)).getStatements().get(0);
            }

            private J.MethodInvocation extractRepository(J.MethodInvocation pluginManagement) {
                J.MethodInvocation repositories = (J.MethodInvocation)((J.Return)((J.Block)((J.Lambda)pluginManagement.getArguments().get(0)).getBody()).getStatements().get(0)).getExpression();
                return (J.MethodInvocation)Objects.requireNonNull(((J.Return)((J.Block)((J.Lambda)Objects.requireNonNull(repositories).getArguments().get(0)).getBody()).getStatements().get(0)).getExpression());
            }
        });
    }

    @Generated
    public AddSettingsPluginRepository(String type, String url) {
        this.type = type;
        this.url = url;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public String getUrl() {
        return this.url;
    }

    @NonNull
    @Generated
    public String toString() {
        return "AddSettingsPluginRepository(type=" + this.getType() + ", url=" + this.getUrl() + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddSettingsPluginRepository)) {
            return false;
        }
        AddSettingsPluginRepository other = (AddSettingsPluginRepository)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        return !(this$url == null ? other$url != null : !this$url.equals(other$url));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof AddSettingsPluginRepository;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        return result;
    }
}

