/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle;

import java.time.Duration;
import java.util.List;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.gradle.IsBuildGradle;
import org.openrewrite.gradle.trait.GradleDependency;
import org.openrewrite.gradle.util.Dependency;
import org.openrewrite.gradle.util.DependencyStringNotationConverter;
import org.openrewrite.groovy.GroovyIsoVisitor;
import org.openrewrite.groovy.tree.G;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.semver.DependencyMatcher;

public final class ChangeDependencyConfiguration
extends Recipe {
    @Option(displayName="Group", description="The first part of a dependency coordinate `com.google.guava:guava:VERSION`. This can be a glob expression.", example="com.fasterxml.jackson*")
    private final String groupId;
    @Option(displayName="Artifact", description="The second part of a dependency coordinate `com.google.guava:guava:VERSION`. This can be a glob expression.", example="jackson-module*")
    private final String artifactId;
    @Option(displayName="New configuration", description="A dependency configuration container.", example="api")
    private final String newConfiguration;
    @Option(displayName="Dependency configuration", description="The dependency configuration to search for dependencies in.", example="api", required=false)
    private final @Nullable String configuration;

    public String getDisplayName() {
        return "Change a Gradle dependency configuration";
    }

    public String getInstanceNameSuffix() {
        return String.format("`%s:%s` to `%s`", this.groupId, this.artifactId, this.newConfiguration);
    }

    public String getDescription() {
        return "A common example is the need to change `compile` to `api`/`implementation` as [part of the move](https://docs.gradle.org/current/userguide/upgrading_version_6.html) to Gradle 7.x and later.";
    }

    public Validated<Object> validate() {
        return super.validate().and(DependencyMatcher.build((String)(this.groupId + ":" + this.artifactId)));
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(5L);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check(new IsBuildGradle(), (TreeVisitor)new GroovyIsoVisitor<ExecutionContext>(){
            final MethodMatcher dependencyDsl = new MethodMatcher("DependencyHandlerSpec *(..)");

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation m = super.visitMethodInvocation(method, (Object)ctx);
                GradleDependency.Matcher gradleDependencyMatcher = new GradleDependency.Matcher().configuration(ChangeDependencyConfiguration.this.configuration);
                if (!gradleDependencyMatcher.get(this.getCursor()).isPresent() && !this.matchesOtherDependency(m)) {
                    return m;
                }
                DependencyMatcher dependencyMatcher = new DependencyMatcher(ChangeDependencyConfiguration.this.groupId, ChangeDependencyConfiguration.this.artifactId, null);
                List args = m.getArguments();
                if (args.get(0) instanceof J.Literal) {
                    J.Literal arg = (J.Literal)args.get(0);
                    if (!(arg.getValue() instanceof String)) {
                        return m;
                    }
                    Dependency dependency = DependencyStringNotationConverter.parse((String)arg.getValue());
                    if (dependency == null || !dependencyMatcher.matches(dependency.getGroupId(), dependency.getArtifactId())) {
                        return m;
                    }
                } else if (args.get(0) instanceof G.GString) {
                    G.GString gString = (G.GString)args.get(0);
                    List strings = gString.getStrings();
                    if (strings.size() != 2 || !(strings.get(0) instanceof J.Literal) || !(strings.get(1) instanceof G.GString.Value)) {
                        return m;
                    }
                    J.Literal groupArtifact = (J.Literal)strings.get(0);
                    if (!(groupArtifact.getValue() instanceof String)) {
                        return m;
                    }
                    Dependency dependency = DependencyStringNotationConverter.parse((String)groupArtifact.getValue());
                    if (dependency == null || !dependencyMatcher.matches(dependency.getGroupId(), dependency.getArtifactId())) {
                        return m;
                    }
                } else if (args.get(0) instanceof G.MapEntry) {
                    if (args.size() < 2) {
                        return m;
                    }
                    String groupId = null;
                    String artifactId = null;
                    for (Expression e : args) {
                        G.MapEntry arg;
                        if (!(e instanceof G.MapEntry) || !((arg = (G.MapEntry)e).getKey() instanceof J.Literal) || !(arg.getValue() instanceof J.Literal)) continue;
                        J.Literal key = (J.Literal)arg.getKey();
                        J.Literal value = (J.Literal)arg.getValue();
                        if (!(key.getValue() instanceof String) || !(value.getValue() instanceof String)) continue;
                        String keyValue = (String)key.getValue();
                        String valueValue = (String)value.getValue();
                        if ("group".equals(keyValue)) {
                            groupId = valueValue;
                            continue;
                        }
                        if (!"name".equals(keyValue)) continue;
                        artifactId = valueValue;
                    }
                    if (artifactId == null || !dependencyMatcher.matches(groupId, artifactId)) {
                        return m;
                    }
                } else if (args.get(0) instanceof G.MapLiteral) {
                    if (args.size() < 2) {
                        return m;
                    }
                    G.MapLiteral map = (G.MapLiteral)args.get(0);
                    String groupId = null;
                    String artifactId = null;
                    for (G.MapEntry arg : map.getElements()) {
                        if (!(arg.getKey() instanceof J.Literal) || !(arg.getValue() instanceof J.Literal)) continue;
                        J.Literal key = (J.Literal)arg.getKey();
                        J.Literal value = (J.Literal)arg.getValue();
                        if (!(key.getValue() instanceof String) || !(value.getValue() instanceof String)) continue;
                        String keyValue = (String)key.getValue();
                        String valueValue = (String)value.getValue();
                        if ("group".equals(keyValue)) {
                            groupId = valueValue;
                            continue;
                        }
                        if (!"name".equals(keyValue)) continue;
                        artifactId = valueValue;
                    }
                    if (artifactId == null || !dependencyMatcher.matches(groupId, artifactId)) {
                        return m;
                    }
                } else if (args.get(0) instanceof J.MethodInvocation) {
                    J.MethodInvocation inner = (J.MethodInvocation)args.get(0);
                    if (!(inner.getSimpleName().equals("project") || inner.getSimpleName().equals("platform") || inner.getSimpleName().equals("enforcedPlatform"))) {
                        return m;
                    }
                    List innerArgs = inner.getArguments();
                    if (!(innerArgs.get(0) instanceof J.Literal)) {
                        return m;
                    }
                    J.Literal value = (J.Literal)innerArgs.get(0);
                    if (!(value.getValue() instanceof String)) {
                        return m;
                    }
                    Dependency dependency = inner.getSimpleName().equals("project") ? new Dependency("", ((String)value.getValue()).substring(1), null, null, null) : DependencyStringNotationConverter.parse((String)value.getValue());
                    if (dependency == null || !dependencyMatcher.matches(dependency.getGroupId(), dependency.getArtifactId())) {
                        return m;
                    }
                } else {
                    return m;
                }
                if (ChangeDependencyConfiguration.this.newConfiguration.equals(m.getSimpleName())) {
                    return m;
                }
                return m.withName(m.getName().withSimpleName(ChangeDependencyConfiguration.this.newConfiguration));
            }

            private boolean matchesOtherDependency(J.MethodInvocation m) {
                if (!this.dependencyDsl.matches((MethodCall)m)) {
                    return false;
                }
                if (m.getArguments().isEmpty() || !(m.getArguments().get(0) instanceof J.MethodInvocation)) {
                    return false;
                }
                J.MethodInvocation inner = (J.MethodInvocation)m.getArguments().get(0);
                if (!(inner.getSimpleName().equals("project") || inner.getSimpleName().equals("platform") || inner.getSimpleName().equals("enforcedPlatform"))) {
                    return false;
                }
                return StringUtils.isBlank((String)ChangeDependencyConfiguration.this.configuration) || ChangeDependencyConfiguration.this.configuration.equals(m.getSimpleName());
            }
        });
    }

    @Generated
    public ChangeDependencyConfiguration(String groupId, String artifactId, String newConfiguration, @Nullable String configuration) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.newConfiguration = newConfiguration;
        this.configuration = configuration;
    }

    @Generated
    public String getGroupId() {
        return this.groupId;
    }

    @Generated
    public String getArtifactId() {
        return this.artifactId;
    }

    @Generated
    public String getNewConfiguration() {
        return this.newConfiguration;
    }

    @Generated
    public @Nullable String getConfiguration() {
        return this.configuration;
    }

    @NonNull
    @Generated
    public String toString() {
        return "ChangeDependencyConfiguration(groupId=" + this.getGroupId() + ", artifactId=" + this.getArtifactId() + ", newConfiguration=" + this.getNewConfiguration() + ", configuration=" + this.getConfiguration() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangeDependencyConfiguration)) {
            return false;
        }
        ChangeDependencyConfiguration other = (ChangeDependencyConfiguration)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        String this$artifactId = this.getArtifactId();
        String other$artifactId = other.getArtifactId();
        if (this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId)) {
            return false;
        }
        String this$newConfiguration = this.getNewConfiguration();
        String other$newConfiguration = other.getNewConfiguration();
        if (this$newConfiguration == null ? other$newConfiguration != null : !this$newConfiguration.equals(other$newConfiguration)) {
            return false;
        }
        String this$configuration = this.getConfiguration();
        String other$configuration = other.getConfiguration();
        return !(this$configuration == null ? other$configuration != null : !this$configuration.equals(other$configuration));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof ChangeDependencyConfiguration;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        String $artifactId = this.getArtifactId();
        result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
        String $newConfiguration = this.getNewConfiguration();
        result = result * 59 + ($newConfiguration == null ? 43 : $newConfiguration.hashCode());
        String $configuration = this.getConfiguration();
        result = result * 59 + ($configuration == null ? 43 : $configuration.hashCode());
        return result;
    }
}

