/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle.search;

import java.nio.file.Paths;
import java.util.Objects;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.gradle.marker.GradleProject;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.marker.SearchResult;

public final class FindGradleProject
extends Recipe {
    @Option(displayName="Search criteria", description="Whether to identify gradle projects by source file name or the presence of a marker", valid={"File", "Marker"}, example="Marker")
    private final @Nullable SearchCriteria searchCriteria;

    public String getDisplayName() {
        return "Find Gradle projects";
    }

    public String getDescription() {
        return "Gradle projects are those with `build.gradle` or `build.gradle.kts` files.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        if (this.searchCriteria == SearchCriteria.Marker) {
            return new TreeVisitor<Tree, ExecutionContext>(){

                public Tree preVisit(Tree tree, ExecutionContext ctx) {
                    JavaSourceFile cu;
                    this.stopAfterPreVisit();
                    if (tree instanceof JavaSourceFile && (cu = (JavaSourceFile)Objects.requireNonNull(tree)).getMarkers().findFirst(GradleProject.class).isPresent()) {
                        return SearchResult.found((Tree)cu);
                    }
                    return tree;
                }
            };
        }
        return new TreeVisitor<Tree, ExecutionContext>(){

            public Tree preVisit(Tree tree, ExecutionContext ctx) {
                if (tree instanceof SourceFile) {
                    this.stopAfterPreVisit();
                    SourceFile sourceFile = (SourceFile)tree;
                    if (sourceFile.getSourcePath().endsWith(Paths.get("build.gradle", new String[0])) || sourceFile.getSourcePath().endsWith(Paths.get("build.gradle.kts", new String[0]))) {
                        return SearchResult.found((Tree)sourceFile);
                    }
                }
                return tree;
            }
        };
    }

    @Generated
    public FindGradleProject(@Nullable SearchCriteria searchCriteria) {
        this.searchCriteria = searchCriteria;
    }

    @Generated
    public @Nullable SearchCriteria getSearchCriteria() {
        return this.searchCriteria;
    }

    @NonNull
    @Generated
    public String toString() {
        return "FindGradleProject(searchCriteria=" + (Object)((Object)this.getSearchCriteria()) + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindGradleProject)) {
            return false;
        }
        FindGradleProject other = (FindGradleProject)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        SearchCriteria this$searchCriteria = this.getSearchCriteria();
        SearchCriteria other$searchCriteria = other.getSearchCriteria();
        return !(this$searchCriteria == null ? other$searchCriteria != null : !((Object)((Object)this$searchCriteria)).equals((Object)other$searchCriteria));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof FindGradleProject;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SearchCriteria $searchCriteria = this.getSearchCriteria();
        result = result * 59 + ($searchCriteria == null ? 43 : ((Object)((Object)$searchCriteria)).hashCode());
        return result;
    }

    public static enum SearchCriteria {
        File,
        Marker;

    }
}

